/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.net;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ConnectionIdleHandler
extends IdleStateHandler {
    private static final Logger log = LoggerFactory.getLogger(ConnectionIdleHandler.class);

    public ConnectionIdleHandler(int timeoutSeconds) {
        super((long)timeoutSeconds, 0L, 0L, TimeUnit.SECONDS);
    }

    protected final void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
        assert (evt.state() == IdleState.READER_IDLE);
        if (log.isInfoEnabled()) {
            log.info(String.format("Close connection %s because read idle timeout", ctx.channel()));
        }
        ctx.close();
    }
}

