/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.net;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ConnectionLimitHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(ConnectionLimitHandler.class);
    private final long maxConnection;
    private AtomicLong connection = new AtomicLong(0L);

    public ConnectionLimitHandler(long maxConnection) {
        this.maxConnection = maxConnection;
        if (log.isInfoEnabled()) {
            log.info(String.format("Max connections: %s", maxConnection));
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Creating connection: %s/%s.", this.connection.get(), this.maxConnection));
        }
        if (this.connection.getAndIncrement() >= this.maxConnection) {
            if (log.isDebugEnabled()) {
                log.debug("Connection too much, close it");
            }
            ctx.writeAndFlush((Object)Response.error(ErrorCode.TOO_MANY_CONNECTIONS, new String[0])).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.connection.decrementAndGet();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Closed connection: %s/%s.", this.connection.get(), this.maxConnection));
        }
    }
}

