/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.net;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.CodecException;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import kd.bos.xcache.server.exception.CacheServerRuntimeException;
import kd.bos.xcache.server.exception.CodecErrorException;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.exception.ErrorCodeException;
import kd.bos.xcache.server.net.ReleasableAttachmentUtil;
import kd.bos.xcache.server.protocol.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandler
extends ChannelDuplexHandler {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandler.class);

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.doExceptionCaught(ctx, cause);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        ctx.write(msg, promise.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (!future.isSuccess()) {
                this.doExceptionCaught(ctx, future.cause());
            }
        })));
    }

    public void doExceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ReleasableAttachmentUtil.clearAll(ctx.channel());
        if (cause instanceof IOException) {
            if (ctx.channel().isActive() && ctx.channel().isOpen()) {
                ctx.channel().close();
                if (log.isInfoEnabled()) {
                    log.info(String.format("Close connection %s because client already closed", ctx.channel()));
                }
            }
        } else {
            String message;
            if (!ctx.channel().isOpen() || !ctx.channel().isActive()) {
                if (log.isErrorEnabled()) {
                    log.error(String.format("UnExcepted channel[%s] status %s", ctx.channel(), cause));
                }
                return;
            }
            ErrorCodeException codeException = this.getServerCacheException(cause);
            int status = codeException != null ? codeException.getErrorCode().getCode() : ErrorCode.ERROR.getCode();
            String string = codeException != null ? codeException.getMessage() : (message = ErrorCode.ERROR.format(cause != null ? cause.getMessage() : ""));
            if (status == ErrorCode.ERROR.getCode()) {
                log.warn(message, cause);
            } else if (codeException instanceof CacheServerRuntimeException) {
                log.info(message);
            }
            ctx.channel().writeAndFlush((Object)Response.builder().status(status).error(message).build());
        }
    }

    private ErrorCodeException getServerCacheException(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof ErrorCodeException) {
            return (ErrorCodeException)((Object)throwable);
        }
        if (throwable instanceof CodecException) {
            return new CodecErrorException((CodecException)throwable);
        }
        return this.getServerCacheException(throwable.getCause());
    }
}

