/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.net;

import io.netty.channel.Channel;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.xcache.server.common.Releasable;
import kd.bos.xcache.server.net.AttachmentKey;

public class ReleasableAttachmentUtil {
    private ReleasableAttachmentUtil() {
    }

    public static void channelInit(Channel ch) {
        ReleasableAttachmentUtil.initAttachmentMap(ch);
    }

    public static Releasable get(Channel ch, String key) {
        Map<String, Releasable> map = ReleasableAttachmentUtil.getAttachmentMap(ch);
        return map.get(key);
    }

    public static Releasable put(Channel ch, String key, Releasable referenceCounted) {
        Map<String, Releasable> map = ReleasableAttachmentUtil.getAttachmentMap(ch);
        return map.put(key, referenceCounted);
    }

    public static Releasable remove(Channel ch, String key) {
        Map<String, Releasable> map = ReleasableAttachmentUtil.getAttachmentMap(ch);
        return map.remove(key);
    }

    public static Set<Releasable> clearAll(Channel ch) {
        Map<String, Releasable> map = ReleasableAttachmentUtil.getAttachmentMap(ch);
        HashSet<Releasable> result = new HashSet<Releasable>();
        for (String key : map.keySet()) {
            map.remove(key).release();
        }
        return result;
    }

    private static void initAttachmentMap(Channel ch) {
        ch.attr(AttachmentKey.RELEASABLE_ATTACHMENT).set(new ConcurrentHashMap());
    }

    private static Map<String, Releasable> getAttachmentMap(Channel ch) {
        return (Map)ch.attr(AttachmentKey.RELEASABLE_ATTACHMENT).get();
    }
}

