/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.net;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.net.InetSocketAddress;
import kd.bos.xcache.server.ServerContext;
import kd.bos.xcache.server.config.ServerPlatform;
import kd.bos.xcache.server.net.AttachmentKey;
import kd.bos.xcache.server.net.ChannelCodecInitializer;
import kd.bos.xcache.server.net.ChannelLifeHandler;
import kd.bos.xcache.server.net.ClientInfo;
import kd.bos.xcache.server.net.ConnectionIdleHandler;
import kd.bos.xcache.server.net.ConnectionLimitHandler;
import kd.bos.xcache.server.net.ExceptionHandler;
import kd.bos.xcache.server.net.HandlerNames;
import kd.bos.xcache.server.net.RequestHandler;
import kd.bos.xcache.server.net.redis.RedisChannelInitializer;
import org.apache.commons.lang3.tuple.Pair;

public class ServerChannelInitializer
extends ChannelInitializer<Channel> {
    private ServerContext context;
    private ChannelLifeHandler lifeHandler;
    private ConnectionLimitHandler limitHandler;
    private ChannelCodecInitializer codecInitializer;

    public ServerChannelInitializer(ServerContext context) {
        this.context = context;
        this.limitHandler = new ConnectionLimitHandler(ServerPlatform.maxConnection());
        this.lifeHandler = new ChannelLifeHandler();
        this.codecInitializer = new RedisChannelInitializer();
    }

    protected void initChannel(Channel ch) {
        ServerChannelInitializer.initClientInfo(ch);
        ch.pipeline().addLast(HandlerNames.HEAD_DEBUG_LOGGER.name(), (ChannelHandler)new LoggingHandler(LogLevel.DEBUG));
        ch.pipeline().addLast(HandlerNames.CHANNEL_LIFE_HANDLER.name(), (ChannelHandler)this.lifeHandler);
        ch.pipeline().addLast(new ChannelHandler[]{new ConnectionIdleHandler(ServerPlatform.maxReadIdleSeconds())});
        this.addEncoders(ch.pipeline());
        ch.pipeline().addLast(HandlerNames.CONNECTION_LIMIT_HANDLER.name(), (ChannelHandler)this.limitHandler);
        this.addDecoders(ch.pipeline());
        ch.pipeline().addLast(HandlerNames.REQUEST_HANDLER.name(), (ChannelHandler)new RequestHandler(this.context));
        ch.pipeline().addLast(HandlerNames.EXCEPTION_HANDLER.name(), (ChannelHandler)new ExceptionHandler());
        ch.pipeline().addLast(HandlerNames.TAIL_DEBUG_LOGGER.name(), (ChannelHandler)new LoggingHandler(LogLevel.DEBUG));
    }

    private static void initClientInfo(Channel ch) {
        ClientInfo clientInfo = ClientInfo.LOCAL;
        if (ch.localAddress() instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)ch.localAddress();
            clientInfo = new ClientInfo(address.getHostString(), address.getPort());
        }
        ch.attr(AttachmentKey.CLIENT_INFO).set((Object)clientInfo);
    }

    protected void addDecoders(ChannelPipeline pipeline) {
        for (Pair<String, ChannelInboundHandlerAdapter> each : this.codecInitializer.decoders()) {
            pipeline.addLast((String)each.getKey(), (ChannelHandler)each.getValue());
        }
    }

    protected void addEncoders(ChannelPipeline pipeline) {
        for (Pair<String, ChannelOutboundHandlerAdapter> each : this.codecInitializer.encoders()) {
            pipeline.addLast((String)each.getKey(), (ChannelHandler)each.getValue());
        }
    }
}

