/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.net.redis;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.redis.ArrayHeaderRedisMessage;
import io.netty.handler.codec.redis.BulkStringHeaderRedisMessage;
import io.netty.handler.codec.redis.BulkStringRedisContent;
import io.netty.handler.codec.redis.InlineCommandRedisMessage;
import io.netty.handler.codec.redis.RedisMessage;
import java.util.List;
import java.util.Optional;
import kd.bos.xcache.server.common.Releasable;
import kd.bos.xcache.server.exception.NetProtocolErrorException;
import kd.bos.xcache.server.exception.UnsupportedCommandException;
import kd.bos.xcache.server.exception.UnsupportedMessageTypeException;
import kd.bos.xcache.server.net.ReleasableAttachmentUtil;
import kd.bos.xcache.server.net.redis.RedisRequestBuilder;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisRequestDecoder
extends MessageToMessageDecoder<RedisMessage> {
    private static final Logger log = LoggerFactory.getLogger(RedisRequestDecoder.class);
    static final String REDIS_REQUEST_BUILDER_KEY = "REDIS_REQUEST_BUILDER";

    protected void decode(ChannelHandlerContext ctx, RedisMessage redisMessage, List<Object> out) throws Exception {
        RedisRequestBuilder builder = RedisRequestDecoder.getBuilder(ctx);
        if (redisMessage instanceof ArrayHeaderRedisMessage) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("create request builder: %s", ((ArrayHeaderRedisMessage)redisMessage).length()));
            }
            assert (builder == null);
            builder = RedisRequestBuilder.builder(ctx.alloc(), (ArrayHeaderRedisMessage)redisMessage);
            RedisRequestDecoder.setBuilder(ctx, builder);
        } else if (redisMessage instanceof BulkStringHeaderRedisMessage) {
            this.check(builder);
            if (log.isDebugEnabled()) {
                log.debug(String.format("get redis bulk string header: %s", ((BulkStringHeaderRedisMessage)redisMessage).bulkStringLength()));
            }
            builder.nextBulkHeader((BulkStringHeaderRedisMessage)redisMessage);
        } else if (redisMessage instanceof BulkStringRedisContent) {
            this.check(builder);
            if (log.isDebugEnabled()) {
                log.debug(String.format("get redis bulk string content %s %s", redisMessage.getClass(), ((BulkStringRedisContent)redisMessage).content().readableBytes()));
            }
            builder.nextBulkContent((BulkStringRedisContent)redisMessage);
            if (builder.isDone()) {
                out.add(builder.build());
                RedisRequestDecoder.clearBuilder(ctx);
            }
        } else if (redisMessage instanceof InlineCommandRedisMessage) {
            RedisRequestDecoder.handleInlineCommand((InlineCommandRedisMessage)redisMessage, out);
        } else {
            if (log.isWarnEnabled()) {
                log.warn(String.format("unknown redis message type %s ", redisMessage.getClass()));
            }
            throw new UnsupportedMessageTypeException(redisMessage.getClass().getSimpleName());
        }
    }

    private void check(RedisRequestBuilder builder) {
        if (null == builder) {
            throw new NetProtocolErrorException("Invalid message, need begin with array or inline command");
        }
    }

    private static void clearBuilder(ChannelHandlerContext ctx) {
        ReleasableAttachmentUtil.remove(ctx.channel(), REDIS_REQUEST_BUILDER_KEY);
    }

    private static Releasable setBuilder(ChannelHandlerContext ctx, RedisRequestBuilder builder) {
        return ReleasableAttachmentUtil.put(ctx.channel(), REDIS_REQUEST_BUILDER_KEY, builder);
    }

    private static RedisRequestBuilder getBuilder(ChannelHandlerContext ctx) {
        return (RedisRequestBuilder)ReleasableAttachmentUtil.get(ctx.channel(), REDIS_REQUEST_BUILDER_KEY);
    }

    private static void handleInlineCommand(InlineCommandRedisMessage redisMessage, List<Object> out) {
        InlineCommandRedisMessage inlineCommandRedisMessage = redisMessage;
        String command = inlineCommandRedisMessage.content().trim();
        Optional<CommandType> commandTypeOptional = CommandType.findCommandType(command);
        if (!commandTypeOptional.isPresent()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Unsupported inline command type %s, could not found CommandType.", command));
            }
            throw new UnsupportedCommandException(command);
        }
        out.add(Request.builder().command(commandTypeOptional.get()).build());
    }
}

