/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.net.redis;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.redis.ArrayHeaderRedisMessage;
import io.netty.handler.codec.redis.ErrorRedisMessage;
import io.netty.handler.codec.redis.FixedRedisMessagePool;
import io.netty.handler.codec.redis.FullBulkStringRedisMessage;
import io.netty.handler.codec.redis.IntegerRedisMessage;
import io.netty.handler.codec.redis.RedisMessage;
import io.netty.handler.codec.redis.SimpleStringRedisMessage;
import java.util.LinkedList;
import java.util.List;
import kd.bos.xcache.server.protocol.Response;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.protocol.ValueType;

public class RedisResponseEncoder
extends MessageToMessageEncoder<Response> {
    public static final SimpleStringRedisMessage SIMPLE_OK_MESSAGE = new SimpleStringRedisMessage("OK");

    protected void encode(ChannelHandlerContext ctx, Response msg, List<Object> out) throws Exception {
        if (msg.getStatus() != 0) {
            RedisResponseEncoder.handleErrorResponse(msg, out);
        } else {
            this.handleSuccessResponse(msg, out);
        }
    }

    private static void handleErrorResponse(Response msg, List<Object> out) {
        ErrorRedisMessage errorRedisMessage = new ErrorRedisMessage(msg.getError());
        out.add(errorRedisMessage);
    }

    private void handleSuccessResponse(Response response, List<Object> out) {
        if (response.getValues() == null) {
            out.add(SIMPLE_OK_MESSAGE);
        } else if (this.isNullValue(response)) {
            out.add(FullBulkStringRedisMessage.NULL_INSTANCE);
        } else {
            RedisResponseEncoder.handleValueResponse(response, out);
        }
    }

    private static void handleValueResponse(Response response, List<Object> out) {
        if (response.isArray()) {
            out.addAll(RedisResponseEncoder.createArrayMessage(response.getValues()));
        } else {
            out.addAll(RedisResponseEncoder.createMessage(response.getValues().get(0)));
        }
    }

    private static List<RedisMessage> createMessage(Value value) {
        LinkedList<RedisMessage> result = new LinkedList<RedisMessage>();
        if (ValueType.LIST == value.getType()) {
            result.addAll(RedisResponseEncoder.createArrayMessage(value.getList()));
        } else {
            result.add(RedisResponseEncoder.createSingleMessage(value));
        }
        return result;
    }

    private static List<RedisMessage> createArrayMessage(List<Value> values) {
        LinkedList<RedisMessage> result = new LinkedList<RedisMessage>();
        result.add((RedisMessage)new ArrayHeaderRedisMessage((long)values.size()));
        for (Value value : values) {
            result.addAll(RedisResponseEncoder.createMessage(value));
        }
        return result;
    }

    private static RedisMessage createSingleMessage(Value value) {
        if (ValueType.BUFFER == value.getType()) {
            ByteBuf byteBuf = value.getBuffer();
            return new FullBulkStringRedisMessage(byteBuf.slice(0, byteBuf.readableBytes()));
        }
        if (ValueType.BYTES == value.getType()) {
            ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])value.getBytes());
            return new FullBulkStringRedisMessage(byteBuf);
        }
        if (ValueType.LONG == value.getType()) {
            IntegerRedisMessage cached = FixedRedisMessagePool.INSTANCE.getInteger(value.getLong().longValue());
            return cached != null ? cached : new IntegerRedisMessage(value.getLong().longValue());
        }
        if (ValueType.STRING == value.getType()) {
            return new SimpleStringRedisMessage(value.getString());
        }
        if (value.isNull()) {
            return FullBulkStringRedisMessage.NULL_INSTANCE;
        }
        throw new CodecException("Unsupported value type " + value.getValue());
    }

    private boolean isNullValue(Response msg) {
        return !msg.isArray() && msg.getValues().size() == 1 && msg.getValues().get(0).isNull();
    }
}

