/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.protocol;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Value;

public class Request
implements Serializable {
    private CommandType command;
    private List<Value> args = new LinkedList<Value>();

    private Request() {
    }

    public CommandType getCommand() {
        return this.command;
    }

    public List<Value> getArgs() {
        return this.args;
    }

    public static RequestBuilder builder() {
        return new RequestBuilder();
    }

    public static class RequestBuilder {
        private Request request = new Request();

        public RequestBuilder command(CommandType type) {
            this.request.command = type;
            return this;
        }

        public RequestBuilder args(Value<?> ... args) {
            if (args != null) {
                for (Value<?> each : args) {
                    this.request.args.add(each);
                }
            }
            return this;
        }

        public RequestBuilder args(Collection<Value<?>> args) {
            if (args != null) {
                for (Value<?> each : args) {
                    this.request.args.add(each);
                }
            }
            return this;
        }

        public Request build() {
            return this.request;
        }
    }
}

