/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.protocol;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.Value;

public class Response
implements Serializable {
    public static final Response NOT_VALUE_SUCCESS = Response.builder().status(0).buildWithNoneValue();
    private int status;
    private String error;
    private boolean isArray;
    private List<Value> values = new LinkedList<Value>();

    private Response() {
    }

    public int getStatus() {
        return this.status;
    }

    public String getError() {
        return this.error;
    }

    public List<Value> getValues() {
        return this.values;
    }

    public boolean isArray() {
        return this.isArray || this.values != null && this.values.size() > 1;
    }

    public static Response error(ErrorCode errorCode, String ... message) {
        Response response = new Response();
        response.status = errorCode.getCode();
        response.error = errorCode.format(message);
        return response;
    }

    public static ResponseBuilder builder() {
        return new ResponseBuilder();
    }

    public static class ResponseBuilder {
        private Response response = new Response();

        public ResponseBuilder status(int status) {
            this.response.status = status;
            return this;
        }

        public ResponseBuilder error(String error) {
            this.response.error = error;
            return this;
        }

        public ResponseBuilder isArray(boolean isArray) {
            this.response.isArray = isArray;
            return this;
        }

        public ResponseBuilder values(Value ... values) {
            if (values != null) {
                for (Value each : values) {
                    this.response.values.add(each);
                }
            }
            return this;
        }

        public ResponseBuilder values(Collection<Value> values) {
            if (values != null) {
                for (Value each : values) {
                    this.response.values.add(each);
                }
            }
            return this;
        }

        public Response build() {
            return this.response;
        }

        public Response buildWithNoneValue() {
            this.response.values = null;
            this.response.isArray = false;
            return this.response;
        }
    }
}

