/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.result;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kd.bos.xcache.server.exception.ResultConvertFailedException;
import kd.bos.xcache.server.protocol.Response;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.protocol.ValueType;
import kd.bos.xcache.server.result.model.FailedValueBuilder;
import kd.bos.xcache.server.result.model.MultiValueResult;
import kd.bos.xcache.server.result.model.NoValueResult;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.result.model.SingleValueResult;
import kd.bos.xcache.server.result.model.SuccessValueBuilder;

public class Convertors {
    Convertors() {
    }

    public Response convert2Response(Result result) {
        if (result.isSuccess()) {
            return Convertors.handleSuccessResult(result);
        }
        return Convertors.handleFailedResult(result);
    }

    private static Response handleFailedResult(Result result) {
        return Response.builder().status(result.getStatus()).error(result.getError()).buildWithNoneValue();
    }

    private static Response handleSuccessResult(Result result) {
        Response.ResponseBuilder builder = Response.builder();
        if (result instanceof NoValueResult) {
            return builder.buildWithNoneValue();
        }
        if (result instanceof SingleValueResult) {
            builder.values((Value)((SingleValueResult)result).getData());
        } else if (result instanceof MultiValueResult) {
            builder.isArray(true);
            builder.values((Collection)((MultiValueResult)result).getData());
        } else {
            Convertors.unknownResultType(result);
        }
        return builder.build();
    }

    public Result merge(List<Result> results) {
        if (results == null || results.isEmpty()) {
            return SuccessValueBuilder.newBuilder().andReturnOperationOK();
        }
        LinkedList<Value> values = new LinkedList<Value>();
        boolean hasNoValueResult = false;
        for (Result result : results) {
            if (!result.isSuccess()) {
                return FailedValueBuilder.newBuilder().andError(result.getStatus(), result.getError());
            }
            if (result instanceof NoValueResult) {
                hasNoValueResult = true;
                continue;
            }
            if (result instanceof SingleValueResult) {
                Convertors.checkMergeAble(result, hasNoValueResult);
                values.add((Value)((SingleValueResult)result).getData());
                continue;
            }
            if (result instanceof MultiValueResult) {
                Convertors.checkMergeAble(result, hasNoValueResult);
                values.addAll((Collection)((MultiValueResult)result).getData());
                continue;
            }
            Convertors.unknownResultType(result);
        }
        if (hasNoValueResult) {
            return SuccessValueBuilder.newBuilder().andReturnOperationOK();
        }
        return SuccessValueBuilder.newBuilder().andReturnArray(values);
    }

    public Result sum(List<Result> results) {
        if (results == null) {
            return SuccessValueBuilder.newBuilder().andReturn(Value.LONG_ZERO);
        }
        long sum = 0L;
        Result error = null;
        for (Result result : results) {
            if (!result.isSuccess()) {
                error = Convertors.handleFailed(result, error);
                continue;
            }
            if (result instanceof SingleValueResult) {
                sum = Convertors.handleSingleValue(result, sum);
                continue;
            }
            Convertors.sumSupportedType(result);
        }
        if (error != null) {
            return error;
        }
        return SuccessValueBuilder.newBuilder().andReturn(Value.newLong(sum));
    }

    private static long handleSingleValue(Result result, long sum) {
        Value data = (Value)((SingleValueResult)result).getData();
        if (ValueType.LONG == data.getType()) {
            sum += data.getLong().longValue();
        } else {
            Convertors.sumSupportedType(result);
        }
        return sum;
    }

    private static Result handleFailed(Result result, Result error) {
        if (error == null) {
            error = FailedValueBuilder.newBuilder().andError(result.getStatus(), result.getError());
        }
        return error;
    }

    private static void unknownResultType(Result result) {
        throw new ResultConvertFailedException(String.format("Unknown result type : %s", result.getClass().getName()));
    }

    private static void checkMergeAble(Result result, boolean hasNoValueResult) {
        if (hasNoValueResult) {
            throw new ResultConvertFailedException(String.format("%s cannot merge with no value type result.", result.getClass().getName()));
        }
    }

    private static void sumSupportedType(Result result) {
        throw new ResultConvertFailedException(String.format("could not merge result[%s] which value not a single long type", result.getClass().getSimpleName()));
    }
}

