/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.schedule;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.xcache.server.ServerContext;
import kd.bos.xcache.server.invoker.InvokeFailedHandler;
import kd.bos.xcache.server.schedule.TimerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScheduleTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(AbstractScheduleTask.class);
    protected ServerContext serverContext;
    private ScheduledExecutorService service;
    protected TimerMetrics metrics;
    protected final InvokeFailedHandler defaultErrorHandler = e -> {
        this.schedule();
        if (log.isWarnEnabled()) {
            log.warn(String.format("Error occurred when execute %s: %s", this.name(), e.getMessage()));
        }
    };

    protected AbstractScheduleTask(ServerContext serverContext, ScheduledExecutorService service, TimerMetrics metrics) {
        this.serverContext = serverContext;
        this.service = service;
        this.metrics = metrics;
    }

    public final void start() {
        this.schedule();
    }

    protected void schedule() {
        this.service.schedule(this, this.nextTime(), this.timeUnit());
    }

    public abstract TimeUnit timeUnit();

    public abstract long nextTime();

    public String name() {
        return this.getClass().getSimpleName();
    }
}

