/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.schedule;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.xcache.server.ServerContext;
import kd.bos.xcache.server.cmd.model.ClearExpireCommand;
import kd.bos.xcache.server.schedule.PeriodFixedScheduleTask;
import kd.bos.xcache.server.schedule.TimerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpireCacheClearTask
extends PeriodFixedScheduleTask {
    private static final Logger log = LoggerFactory.getLogger(ExpireCacheClearTask.class);

    public ExpireCacheClearTask(ServerContext serverContext, ScheduledExecutorService service, TimerMetrics metrics) {
        super(serverContext, service, metrics, TimeUnit.SECONDS, 10L);
    }

    @Override
    public void run() {
        this.serverContext.getCommandInvokers().newLongInvoker(new ClearExpireCommand()).onError(this.defaultErrorHandler).onSuccess(v -> {
            this.schedule();
            if (v > 0L) {
                this.metrics.incrementClearExpireCacheCount((long)v);
            }
            if (log.isDebugEnabled()) {
                log.debug(String.format("Cleared %s expire caches.", v));
            }
        }).invoke();
    }
}

