/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.schedule;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kd.bos.xcache.server.ServerContext;
import kd.bos.xcache.server.common.ThreadFactories;
import kd.bos.xcache.server.metric.MetricsCenter;
import kd.bos.xcache.server.schedule.AbstractScheduleTask;
import kd.bos.xcache.server.schedule.ScheduleTaskRegistry;
import kd.bos.xcache.server.schedule.TimerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleTaskManager {
    private static final Logger log = LoggerFactory.getLogger(ScheduleTaskManager.class);
    protected final TimerMetrics metrics;
    protected final ServerContext serverContext;
    final ScheduleTaskRegistry registry;
    private final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(ThreadFactories.get().newNamedDaemon("schedule-"));

    public ScheduleTaskManager(ServerContext serverContext) {
        this.serverContext = serverContext;
        this.metrics = new TimerMetrics();
        MetricsCenter.get().register(this.metrics);
        this.registry = new ScheduleTaskRegistry(this.serverContext, this.service, this.metrics);
    }

    public void start() {
        for (String key : this.registry.keys()) {
            AbstractScheduleTask task = (AbstractScheduleTask)this.registry.find(key);
            if (log.isInfoEnabled()) {
                log.info(String.format("Start schedule task %s", task.name()));
            }
            task.start();
        }
    }

    public void stop() {
        this.service.shutdown();
    }
}

