/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.store.basic;

import java.util.Arrays;
import kd.bos.xcache.server.store.basic.Computable;
import kd.bos.xcache.server.util.MemoryCalculator;

public final class BinaryString
implements Computable {
    private static final int OBJECT_MEMORY = MemoryCalculator.calculate(BinaryString.class);
    private final byte[] value;
    private int hash;

    public static BinaryString wrap(byte[] bytes) {
        return new BinaryString(bytes);
    }

    public static BinaryString of(String string) {
        return new BinaryString(string.getBytes());
    }

    private BinaryString(byte[] value) {
        this.value = value;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Arrays.hashCode(this.value);
        }
        return this.hash;
    }

    public int length() {
        return this.value.length;
    }

    public byte[] bytes() {
        return this.value;
    }

    @Override
    public int memSize() {
        return OBJECT_MEMORY + this.value.length;
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (!(o instanceof BinaryString)) {
            return false;
        }
        return Arrays.equals(this.value, ((BinaryString)o).value);
    }

    public String toString() {
        return new String(this.bytes());
    }
}

