/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.store.data.string;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.util.Longs;
import kd.bos.xcache.server.util.MemoryCalculator;

public class NumberCache
extends CacheObject<Long> {
    private static final int OBJECT_MEMORY = MemoryCalculator.calculate(NumberCache.class);
    private volatile long value;
    private static AtomicLongFieldUpdater<NumberCache> valueUpdater = AtomicLongFieldUpdater.newUpdater(NumberCache.class, "value");

    public NumberCache(long value) {
        this.value = value;
    }

    @Override
    public int memSize() {
        return OBJECT_MEMORY;
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    public long increment(long add) {
        return valueUpdater.addAndGet(this, add);
    }

    @Override
    public String type() {
        return "string";
    }

    @Override
    public long length() {
        return Longs.stringSize(this.value);
    }

    @Override
    public void release() {
    }
}

