/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.store.data.string;

import kd.bos.xcache.server.store.basic.BufferString;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.util.MemoryCalculator;

public class StringCache
extends CacheObject<BufferString> {
    private static final int OBJECT_MEMORY = MemoryCalculator.calculate(StringCache.class);
    private BufferString value;

    public static StringCache of(BufferString bufferString) {
        return new StringCache(bufferString);
    }

    private StringCache(BufferString value) {
        this.value = value;
    }

    @Override
    public BufferString getValue() {
        return this.value;
    }

    @Override
    public int memSize() {
        return OBJECT_MEMORY + this.value.memSize();
    }

    @Override
    public String type() {
        return "string";
    }

    @Override
    public long length() {
        return this.value.length();
    }

    @Override
    public void release() {
        this.value.release();
    }
}

