/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.store.eviction;

import java.util.Arrays;
import kd.bos.xcache.server.exception.UnExceptedException;
import kd.bos.xcache.server.store.data.node.KeyNode;
import kd.bos.xcache.server.store.eviction.ARCNode;
import kd.bos.xcache.server.store.eviction.ArcNodeCreator;
import kd.bos.xcache.server.store.eviction.EmptyArcNode;
import kd.bos.xcache.server.store.eviction.EvictionListener;
import kd.bos.xcache.server.store.eviction.EvictionPolicy;
import kd.bos.xcache.server.util.Sizes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ARCNodePolicy<T extends KeyNode>
implements EvictionPolicy<ARCNode<T>, T> {
    private static final Logger log = LoggerFactory.getLogger(ARCNodePolicy.class);
    private static final String[] TAGS = new String[]{"NONE", "T1", "T2", "B1", "B2"};
    private static final double TOP_PERCENT = (double)0.8f;
    private long maxWeights;
    private long topMaxWeights;
    private final ARCNode<T>[] lists;
    private final long[] usedWeights;
    private long size;
    private long p;
    private ArcNodeCreator<T> creator;
    private EvictionListener<T> listener;

    public ARCNodePolicy(ArcNodeCreator<T> creator, long maxWeights, EvictionListener<T> listener) {
        this.creator = creator;
        this.listener = listener;
        this.setMaxWeights(maxWeights);
        this.lists = new ARCNode[]{null, this.newSentinel(), this.newSentinel(), this.newSentinel(), this.newSentinel()};
        this.usedWeights = new long[this.lists.length];
        this.size = 0L;
        this.p = 0L;
    }

    @Override
    public ARCNode<T> onAdd(T data) {
        ARCNode<T> node = this.creator.create(data);
        this.touch(node);
        return node;
    }

    @Override
    public void onGet(ARCNode<T> node) {
        this.touch(node);
    }

    void touch(ARCNode<T> node) {
        byte belong = node.getBelong();
        switch (belong) {
            case 1: {
                this.hitT1(node);
                break;
            }
            case 2: {
                this.hitT2(node);
                break;
            }
            case 3: {
                this.hitB1(node);
                break;
            }
            case 4: {
                this.hitB2(node);
                break;
            }
            case 0: {
                this.hitNone(node);
                break;
            }
            default: {
                throw new UnExceptedException(String.format("Illegal node with belong %s", belong));
            }
        }
    }

    private void doDelete(ARCNode<T> node) {
        if (node.isLinked()) {
            node.unlink();
            byte by = node.getBelong();
            this.usedWeights[by] = this.usedWeights[by] - (long)node.weight();
            --this.size;
            node.setBelong((byte)-1);
        }
    }

    @Override
    public void delete(ARCNode<T> node) {
        this.doDelete(node);
    }

    @Override
    public long resetUsedWeights(int percent) {
        long needDecreaseWeight;
        long currentUsed = this.totalUsedWeights();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Max: %s, current used: %s", Sizes.format(this.maxWeights), Sizes.format(currentUsed)));
        }
        if ((needDecreaseWeight = currentUsed - Sizes.percent(currentUsed, percent)) > 0L) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("try to decrease %s", Sizes.format(needDecreaseWeight)));
            }
            return this.doDecrease(needDecreaseWeight);
        }
        return 0L;
    }

    @Override
    public long resetSize(int percent) {
        long needDelete;
        long used = this.size;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Current used: %s", Sizes.format(used)));
        }
        if ((needDelete = used - Sizes.percent(used, percent)) <= 0L) {
            return 0L;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("try to decrease %s caches.", needDelete));
        }
        return this.doResetSize(needDelete);
    }

    @Override
    public void updateWeights(ARCNode<T> node, long incrementWeights) {
        this.usedWeights[node.getBelong()] = this.usedWeights[node.getBelong()] + incrementWeights;
    }

    @Override
    public long usedWeights() {
        return this.totalUsedWeights();
    }

    private void setMaxWeights(long maxWeights) {
        this.maxWeights = maxWeights;
        this.topMaxWeights = (long)((double)maxWeights * (double)0.8f);
    }

    private long doDecrease(long weights) {
        long ensureWeights = this.maxWeights - this.totalUsedWeights() + weights;
        long realEnsureWeights = this.tryDoEnsureWeight(ensureWeights);
        return realEnsureWeights - ensureWeights + weights;
    }

    private void hitNone(ARCNode<T> node) {
        int needWeight = node.weight();
        this.doEnsureWeight(needWeight);
        this.add2First((byte)1, node);
    }

    private void doEnsureWeight(long needWeight) {
        long realEnsured = this.tryDoEnsureWeight(needWeight);
        if (realEnsured < needWeight) {
            throw new UnExceptedException(String.format("Not enough weights(memory) need %s, real %s", needWeight, realEnsured));
        }
    }

    private long tryDoEnsureWeight(long needWeight) {
        this.ensureTListWeights(needWeight);
        return this.doEnsureBListWeight(needWeight);
    }

    private long doEnsureBListWeight(long needWeight) {
        long totalW = this.totalUsedWeights();
        long needDelete = totalW + needWeight - this.maxWeights;
        int current = 3;
        while (needDelete > 0L) {
            ARCNode<T> arcNode = this.getLast((byte)current);
            if (arcNode != null) {
                needDelete -= (long)this.onEvictionNode(arcNode);
                current = current == 3 ? 4 : 3;
                continue;
            }
            arcNode = this.getLast((byte)(current = current == 3 ? 4 : 3));
            if (arcNode == null) break;
            needDelete -= (long)this.onEvictionNode(arcNode);
        }
        return needWeight - needDelete;
    }

    private void ensureTListWeights(long needWeight) {
        int replace;
        for (long needReplace = this.usedWeights[1] + this.usedWeights[2] + needWeight - this.topMaxWeights; needReplace > 0L && (replace = this.replace(needWeight)) > 0; needReplace -= (long)replace) {
        }
    }

    private long doResetSize(long needDelete) {
        assert (needDelete > 0L);
        long deleted = 0L;
        if (needDelete - (deleted += this.doResetSize(needDelete - deleted, (byte)3, (byte)4)) > 0L) {
            deleted += this.doResetSize(needDelete - deleted, (byte)1, (byte)2);
        }
        return deleted;
    }

    private long doResetSize(long needDelete, byte replaceA, byte replaceB) {
        long deleted;
        byte current = replaceA;
        for (deleted = 0L; deleted < needDelete; ++deleted) {
            ARCNode<T> arcNode = this.getLast(current);
            if (arcNode == null) {
                current = current == replaceA ? replaceB : replaceA;
                arcNode = this.getLast(current);
            }
            if (arcNode == null) break;
            this.onEvictionNode(arcNode);
            current = current == replaceA ? replaceB : replaceA;
        }
        return deleted;
    }

    private int onEvictionNode(ARCNode<T> node) {
        if (log.isDebugEnabled()) {
            this.debug("Eviction node " + node.keyInfo() + " from " + TAGS[node.getBelong()]);
        }
        int decreased = node.weight();
        this.doDelete(node);
        if (this.listener != null) {
            this.listener.eviction(node.getData());
        }
        return decreased;
    }

    private void hitB2(ARCNode<T> node) {
        long weight = Math.max(node.weight(), 1);
        long decrease = Math.max(this.usedWeights[3] / (this.usedWeights[4] > 0L ? this.usedWeights[4] : 1L), 1L);
        this.p = Math.max(0L, this.p - decrease * weight);
        this.replace(node.weight());
        this.move2First(node.getBelong(), (byte)2, node);
    }

    private void hitB1(ARCNode<T> node) {
        long weight = Math.max(node.weight(), 1);
        long increase = Math.max(this.usedWeights[4] / (this.usedWeights[3] > 0L ? this.usedWeights[3] : 1L), 1L);
        this.p = Math.min(this.maxWeights, this.p + increase * weight);
        this.replace(node.weight());
        this.move2First(node.getBelong(), (byte)2, node);
    }

    private int replace(long weight) {
        ARCNode<T> last;
        byte from = 2;
        int to = 4;
        if (!this.isEmpty((byte)1) && (this.usedWeights[1] + weight >= this.p || this.isEmpty((byte)2))) {
            from = 1;
            to = 3;
        }
        if ((last = this.removeLast(from)) == null) {
            return 0;
        }
        this.add2First((byte)to, last);
        if (log.isDebugEnabled()) {
            this.debug(String.format("Replaced %s from %s to %s", last.keyInfo(), TAGS[from], TAGS[to]));
        }
        return last.weight();
    }

    private void hitT1(ARCNode<T> node) {
        if (node.isHits()) {
            this.move2First(node.getBelong(), (byte)2, node);
        } else {
            this.move2First(node.getBelong(), node.getBelong(), node);
        }
    }

    private void hitT2(ARCNode<T> node) {
        this.move2First(node.getBelong(), (byte)2, node);
    }

    private ARCNode<T> removeLast(byte belong) {
        ARCNode node = (ARCNode)this.lists[belong].getPrev();
        if (node == this.lists[belong]) {
            return null;
        }
        if (log.isDebugEnabled()) {
            this.debug(String.format("Remove last node %s from %s", node.keyInfo(), TAGS[belong]));
        }
        node.unlink();
        byte by = belong;
        this.usedWeights[by] = this.usedWeights[by] - (long)node.weight();
        --this.size;
        return node;
    }

    private ARCNode<T> getLast(byte belong) {
        ARCNode node = (ARCNode)this.lists[belong].getPrev();
        if (node == this.lists[belong]) {
            return null;
        }
        return node;
    }

    private boolean isEmpty(byte belong) {
        return this.lists[belong].getNext() == this.lists[belong];
    }

    private long totalUsedWeights() {
        return this.usedWeights[1] + this.usedWeights[2] + this.usedWeights[3] + this.usedWeights[4];
    }

    private void move2First(byte oldBelong, byte newBelong, ARCNode<T> node) {
        if (log.isDebugEnabled()) {
            this.debug(String.format("Move %s from %s to %s first", node.keyInfo(), TAGS[oldBelong], TAGS[newBelong]));
        }
        if (oldBelong != newBelong) {
            byte by = oldBelong;
            this.usedWeights[by] = this.usedWeights[by] - (long)node.weight();
            byte by2 = newBelong;
            this.usedWeights[by2] = this.usedWeights[by2] + (long)node.weight();
            node.setHits(false);
        } else {
            node.setHits(true);
        }
        node.unlink();
        node.setBelong(newBelong);
        ARCNode<T> header = this.lists[newBelong];
        node.linkAfter(header);
    }

    private void add2First(byte newBelong, ARCNode<T> node) {
        if (log.isDebugEnabled()) {
            this.debug(String.format("Add %s to %s first", node.keyInfo(), TAGS[newBelong]));
        }
        node.setHits(false);
        byte by = newBelong;
        this.usedWeights[by] = this.usedWeights[by] + (long)node.weight();
        ++this.size;
        node.setBelong(newBelong);
        ARCNode<T> header = this.lists[newBelong];
        node.linkAfter(header);
    }

    private ARCNode<T> newSentinel() {
        return new EmptyArcNode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Size: %s, MaxWeights: %s, TotalWeights: %s, P: %s", this.size, this.maxWeights, this.totalUsedWeights(), this.p));
        sb.append("\n");
        this.appendString((byte)1, sb);
        this.appendString((byte)2, sb);
        this.appendString((byte)3, sb);
        this.appendString((byte)4, sb);
        return sb.toString();
    }

    private void appendString(byte belong, StringBuilder sb) {
        sb.append(String.format("%s[%s]: ", TAGS[belong], this.usedWeights[belong]));
        for (ARCNode current = (ARCNode)this.lists[belong].getNext(); current != this.lists[belong]; current = (ARCNode)current.getNext()) {
            sb.append(String.format("{%s%s}", current.keyInfo(), current.isHits() ? "*" : ""));
        }
        sb.append("\n");
    }

    private void debug(String message) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Size: %s; P:%s; Weights:%s; %s", this.size, this.p, Arrays.toString(this.usedWeights), message));
        }
    }
}

