/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.store.index;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.bos.xcache.server.config.ServerPlatform;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.data.Key;
import kd.bos.xcache.server.store.eviction.ARCNodePolicy;
import kd.bos.xcache.server.store.eviction.EvictionListener;
import kd.bos.xcache.server.store.eviction.EvictionNode;
import kd.bos.xcache.server.store.eviction.EvictionPolicy;
import kd.bos.xcache.server.store.index.CacheDataArcNodeCreator;
import kd.bos.xcache.server.store.index.ExpireCacheDataNode;
import kd.bos.xcache.server.store.index.GlobalIndex;
import kd.bos.xcache.server.store.index.ScanAbleMap;
import kd.bos.xcache.server.store.timer.ExpireListener;
import kd.bos.xcache.server.store.timer.ExpireNode;
import kd.bos.xcache.server.store.timer.MillsTimerWheel;
import kd.bos.xcache.server.store.timer.TimerWheel;
import kd.bos.xcache.server.util.GlobMatcher;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalIndexImpl
implements GlobalIndex {
    private static final Logger log = LoggerFactory.getLogger(GlobalIndexImpl.class);
    private final ScanAbleMap<Key, EvictionNode<ExpireCacheDataNode<Key, CacheObject>>> delegate;
    private final TimerWheel timerWheel;
    private final EvictionPolicy eviction;
    private final long maxMemorySize;
    private final ReadWriteLock dataLock;
    private final Lock evictionLock;

    public GlobalIndexImpl(long maxMemorySize) {
        this.maxMemorySize = maxMemorySize;
        this.delegate = new ScanAbleMap();
        this.dataLock = new ReentrantReadWriteLock();
        this.evictionLock = new ReentrantLock();
        this.timerWheel = new MillsTimerWheel(System.currentTimeMillis(), new ExpireNodeListener());
        this.eviction = new ARCNodePolicy<ExpireCacheDataNode<Key, CacheObject>>(new CacheDataArcNodeCreator(), maxMemorySize, new EvictionNodeListener());
    }

    @Override
    public Lock readLock() {
        return this.dataLock.readLock();
    }

    @Override
    public Lock writeLock() {
        return this.dataLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheObject find(Key key) {
        EvictionNode evictionNode = (EvictionNode)this.delegate.get(key);
        if (evictionNode == null) {
            return null;
        }
        ExpireCacheDataNode node = (ExpireCacheDataNode)evictionNode.getData();
        if (GlobalIndexImpl.notExpired(node)) {
            this.evictionLock.lock();
            try {
                this.eviction.onGet(evictionNode);
            }
            finally {
                this.evictionLock.unlock();
            }
            return (CacheObject)node.getValue();
        }
        this.doDeleteAll(evictionNode);
        return null;
    }

    private void doDeleteData(ExpireCacheDataNode<Key, CacheObject> data) {
        this.timerWheel.cancel(data);
        this.delegate.remove(data.getKey());
        data.release();
    }

    private void doDeleteAll(EvictionNode<ExpireCacheDataNode<Key, CacheObject>> node) {
        if (node == null) {
            return;
        }
        this.evictionLock.lock();
        try {
            this.eviction.delete(node);
        }
        finally {
            this.evictionLock.unlock();
        }
        this.doDeleteData(node.getData());
    }

    @Override
    public void put(Key key, CacheObject cacheObject) {
        this.doPutAndExpire(key, cacheObject, System.currentTimeMillis() + ServerPlatform.defaultExpireTime() * 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMemory(Key key, long increment) {
        EvictionNode evictionNode = (EvictionNode)this.delegate.get(key);
        if (evictionNode != null) {
            this.evictionLock.lock();
            try {
                this.eviction.updateWeights(evictionNode, increment);
            }
            finally {
                this.evictionLock.unlock();
            }
        }
    }

    @Override
    public void putAndExpire(Key key, CacheObject cacheObject, long timeMillis) {
        this.doPutAndExpire(key, cacheObject, timeMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPutAndExpire(Key key, CacheObject cacheObject, long timeMillis) {
        Object node;
        ExpireCacheDataNode<Key, CacheObject> dataNode = new ExpireCacheDataNode<Key, CacheObject>(key, cacheObject, timeMillis);
        EvictionNode existsNode = (EvictionNode)this.delegate.get(key);
        if (existsNode != null) {
            this.doDeleteAll(existsNode);
        }
        this.evictionLock.lock();
        try {
            node = this.eviction.onAdd(dataNode);
        }
        finally {
            this.evictionLock.unlock();
        }
        this.timerWheel.schedule(dataNode);
        this.delegate.put(key, (EvictionNode<ExpireCacheDataNode<Key, CacheObject>>)node);
    }

    @Override
    public Set<Key> allKeys(String pattern) {
        GlobMatcher matcher = GlobMatcher.pattern(pattern, false);
        HashSet<Key> keys = new HashSet<Key>();
        for (EvictionNode each : this.delegate.values()) {
            ExpireCacheDataNode dataNode = (ExpireCacheDataNode)each.getData();
            if (!matcher.match(each.keyInfo()) || !GlobalIndexImpl.notExpired(dataNode)) continue;
            keys.add((Key)dataNode.getKey());
        }
        return keys;
    }

    @Override
    public long size(String pattern) {
        GlobMatcher matcher = GlobMatcher.pattern(pattern, false);
        long result = 0L;
        for (EvictionNode each : this.delegate.values()) {
            if (!matcher.match(each.keyInfo()) || !GlobalIndexImpl.notExpired((ExpireCacheDataNode)each.getData())) continue;
            ++result;
        }
        return result;
    }

    @Override
    public Pair<Integer, List<Pair<Key, CacheObject>>> scan(int cursor, int count) {
        return this.delegate.scan(cursor, count, v -> GlobalIndexImpl.notExpired((ExpireCacheDataNode)v.getData()), v -> (CacheObject)((ExpireCacheDataNode)v.getData()).getValue());
    }

    @Override
    public long size() {
        long result = 0L;
        for (EvictionNode each : this.delegate.values()) {
            if (!GlobalIndexImpl.notExpired((ExpireCacheDataNode)each.getData())) continue;
            ++result;
        }
        return result;
    }

    private static boolean notExpired(ExpireCacheDataNode<Key, CacheObject> dataNode) {
        return dataNode.getExpireTime() > System.currentTimeMillis();
    }

    @Override
    public long remove(List<Key> keys) {
        return this.doRemove(keys);
    }

    @Override
    public void remove(Key key) {
        EvictionNode evictionNode = (EvictionNode)this.delegate.remove(key);
        if (evictionNode != null) {
            this.doDeleteAll(evictionNode);
        }
    }

    private long doRemove(List<Key> keys) {
        long result = 0L;
        if (null == keys || keys.isEmpty()) {
            return result;
        }
        for (Key key : keys) {
            EvictionNode evictionNode = (EvictionNode)this.delegate.remove(key);
            if (evictionNode == null) continue;
            this.doDeleteAll(evictionNode);
            if (!GlobalIndexImpl.notExpired((ExpireCacheDataNode)evictionNode.getData())) continue;
            ++result;
        }
        return result;
    }

    @Override
    public long expireAt(Key key, long timeMillis) {
        EvictionNode evictionNode = (EvictionNode)this.delegate.get(key);
        if (evictionNode == null) {
            return 0L;
        }
        ExpireCacheDataNode<Key, CacheObject> dataNode = this.getAliveDataNode(evictionNode);
        if (dataNode == null) {
            return 0L;
        }
        if (timeMillis > System.currentTimeMillis()) {
            dataNode.setExpireTime(timeMillis);
            this.timerWheel.reschedule(dataNode);
        } else {
            this.doDeleteAll(evictionNode);
        }
        return 1L;
    }

    @Override
    public long ttl(Key key) {
        ExpireCacheDataNode<Key, CacheObject> node = this.getAliveDataNode(key);
        if (node == null) {
            return -2L;
        }
        return (node.getExpireTime() - System.currentTimeMillis()) / 1000L;
    }

    @Override
    public int clearExpire() {
        return this.timerWheel.advance(System.currentTimeMillis());
    }

    @Override
    public long getMaxMemorySize() {
        return this.maxMemorySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long resetUsedMemory(int percent) {
        this.evictionLock.lock();
        try {
            long l = this.eviction.resetUsedWeights(percent);
            return l;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public long usedMemory() {
        this.evictionLock.lock();
        try {
            long l = this.eviction.usedWeights();
            return l;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long resetSize(int percent) {
        this.evictionLock.lock();
        try {
            long l = this.eviction.resetSize(percent);
            return l;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    private ExpireCacheDataNode<Key, CacheObject> getAliveDataNode(Key key) {
        EvictionNode evictionNode = (EvictionNode)this.delegate.get(key);
        if (evictionNode == null) {
            return null;
        }
        return this.getAliveDataNode(evictionNode);
    }

    @Override
    public long clearAll() {
        return this.doRemove(new LinkedList<Key>(this.delegate.keySet()));
    }

    private ExpireCacheDataNode<Key, CacheObject> getAliveDataNode(EvictionNode<ExpireCacheDataNode<Key, CacheObject>> evictionNode) {
        ExpireCacheDataNode<Key, CacheObject> node = evictionNode.getData();
        return GlobalIndexImpl.notExpired(node) ? node : null;
    }

    class EvictionNodeListener
    implements EvictionListener<ExpireCacheDataNode<Key, CacheObject>> {
        EvictionNodeListener() {
        }

        @Override
        public void eviction(ExpireCacheDataNode<Key, CacheObject> data) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Eviction node %s", data.keyInfo()));
            }
            GlobalIndexImpl.this.doDeleteData(data);
        }
    }

    class ExpireNodeListener
    implements ExpireListener {
        ExpireNodeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean expire(ExpireNode node) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Expire node %s", node.keyInfo()));
            }
            ExpireCacheDataNode data = (ExpireCacheDataNode)node;
            data.release();
            EvictionNode evictionNode = (EvictionNode)GlobalIndexImpl.this.delegate.remove(data.getKey());
            GlobalIndexImpl.this.evictionLock.lock();
            try {
                GlobalIndexImpl.this.eviction.delete(evictionNode);
            }
            finally {
                GlobalIndexImpl.this.evictionLock.unlock();
            }
            return true;
        }
    }
}

