/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.store.timer;

import java.util.ArrayList;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import kd.bos.xcache.server.store.data.node.DLinkListDataNode;
import kd.bos.xcache.server.store.timer.ExpireListener;
import kd.bos.xcache.server.store.timer.ExpireNode;
import kd.bos.xcache.server.store.timer.TimerWheel;
import kd.bos.xcache.server.util.Longs;

public class MillsTimerWheel
implements TimerWheel {
    static final int[] BUCKETS = new int[]{64, 64, 32, 4, 1};
    static final long[] SPANS = new long[]{Longs.ceilingPowerOfTwo(TimeUnit.SECONDS.toMillis(1L)), Longs.ceilingPowerOfTwo(TimeUnit.MINUTES.toMillis(1L)), Longs.ceilingPowerOfTwo(TimeUnit.HOURS.toMillis(1L)), Longs.ceilingPowerOfTwo(TimeUnit.DAYS.toMillis(1L)), (long)BUCKETS[3] * Longs.ceilingPowerOfTwo(TimeUnit.DAYS.toMillis(1L)), (long)BUCKETS[3] * Longs.ceilingPowerOfTwo(TimeUnit.DAYS.toMillis(1L))};
    static final long[] SHIFT = new long[]{Long.numberOfTrailingZeros(SPANS[0]), Long.numberOfTrailingZeros(SPANS[1]), Long.numberOfTrailingZeros(SPANS[2]), Long.numberOfTrailingZeros(SPANS[3]), Long.numberOfTrailingZeros(SPANS[4])};
    final ExpireListener listener;
    final ExpireNode[][] wheel;
    long millis;

    public MillsTimerWheel(long currentMillis, ExpireListener listener) {
        this.listener = listener;
        this.millis = currentMillis;
        this.wheel = new ExpireNode[BUCKETS.length][1];
        for (int i = 0; i < this.wheel.length; ++i) {
            this.wheel[i] = new ExpireNode[BUCKETS[i]];
            for (int j = 0; j < this.wheel[i].length; ++j) {
                this.wheel[i][j] = new Sentinel();
            }
        }
    }

    @Override
    public int advance(long currentTimeMillis) {
        int result = 0;
        long previousTimeMillis = this.millis;
        try {
            long previousTicks;
            long currentTicks;
            this.millis = currentTimeMillis;
            for (int i = 0; i < SHIFT.length && (currentTicks = currentTimeMillis >>> (int)SHIFT[i]) - (previousTicks = previousTimeMillis >>> (int)SHIFT[i]) > 0L; ++i) {
                result += this.expire(i, previousTicks, currentTicks);
            }
        }
        catch (RuntimeException t) {
            this.millis = previousTimeMillis;
            throw t;
        }
        return result;
    }

    int expire(int index, long previousTicks, long currentTicks) {
        int start;
        int end;
        int result = 0;
        ExpireNode[] timerWheel = this.wheel[index];
        if (currentTicks - previousTicks >= (long)timerWheel.length) {
            end = timerWheel.length;
            start = 0;
        } else {
            long mask = SPANS[index] - 1L;
            start = (int)(previousTicks & mask);
            end = 1 + (int)(currentTicks & mask);
        }
        int mask = timerWheel.length - 1;
        for (int i = start; i < end; ++i) {
            ExpireNode sentinel = timerWheel[i & mask];
            ExpireNode prev = (ExpireNode)sentinel.getPrev();
            ExpireNode node = (ExpireNode)sentinel.getNext();
            sentinel.setPrev(sentinel);
            sentinel.setNext(sentinel);
            while (node != sentinel) {
                ExpireNode next = (ExpireNode)node.getNext();
                node.setPrev(null);
                node.setNext(null);
                try {
                    if (node.getExpireTime() - this.millis > 0L || !this.listener.expire(node)) {
                        this.schedule(node);
                    } else {
                        ++result;
                    }
                    node = next;
                }
                catch (RuntimeException t) {
                    node.setPrev(sentinel.getPrev());
                    node.setNext(next);
                    ((ExpireNode)sentinel.getPrev()).setNext(node);
                    sentinel.setPrev(prev);
                    throw t;
                }
            }
        }
        return result;
    }

    @Override
    public void schedule(ExpireNode node) {
        ExpireNode sentinel = this.findBucket(node.getExpireTime());
        node.linkBefore(sentinel);
    }

    @Override
    public void reschedule(ExpireNode node) {
        if (node.getNext() != null) {
            node.unlink();
            this.schedule(node);
        }
    }

    @Override
    public void cancel(ExpireNode node) {
        node.unlink();
    }

    ExpireNode findBucket(long time) {
        long duration = time - this.millis;
        int length = this.wheel.length - 1;
        for (int i = 0; i < length; ++i) {
            if (duration >= SPANS[i + 1]) continue;
            long ticks = time >>> (int)SHIFT[i];
            int index = (int)(ticks & (long)(this.wheel[i].length - 1));
            return this.wheel[i][index];
        }
        return this.wheel[length][0];
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.wheel.length; ++i) {
            TreeMap buckets = new TreeMap();
            for (int j = 0; j < this.wheel[i].length; ++j) {
                ArrayList<String> events = new ArrayList<String>();
                for (ExpireNode node = (ExpireNode)this.wheel[i][j].getNext(); node != this.wheel[i][j]; node = (ExpireNode)node.getNext()) {
                    events.add(node.keyInfo());
                }
                if (events.isEmpty()) continue;
                buckets.put(j, events);
            }
            builder.append("Wheel #").append(i + 1).append(": ").append(buckets).append('\n');
        }
        return builder.deleteCharAt(builder.length() - 1).toString();
    }

    static final class Sentinel
    extends DLinkListDataNode<ExpireNode>
    implements ExpireNode {
        Sentinel() {
        }

        @Override
        public String keyInfo() {
            return null;
        }

        @Override
        public long getExpireTime() {
            return 0L;
        }
    }
}

