/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.util;

public class GlobMatcher {
    public static final char EMPTY_CHAR = '\u0000';
    public static final char MATCH_ALL_CHAR = '*';
    public static final char MATCH_ONE_CHAR = '?';
    public static final char SELECT_OPEN_CHAR = '[';
    public static final char NOT_MATCH_CHAR = '^';
    public static final char ESCAPE_CHAR = '\\';
    public static final char SELECT_CLOSE_CHAR = ']';
    public static final char SELECT_LINK_CHAR = '-';
    private boolean skipLongerMatchers;
    private final boolean caseIgnore;
    private final char[] patternChars;
    private final boolean matchAll;

    private GlobMatcher(String pattern, boolean caseIgnore) {
        this.patternChars = pattern != null ? pattern.trim().toCharArray() : new char[]{};
        this.caseIgnore = caseIgnore;
        this.matchAll = this.patternChars.length == 0 || this.patternChars.length == 1 && this.patternChars[0] == '*';
        this.reset();
    }

    public static GlobMatcher pattern(String pattern, boolean caseIgnore) {
        return new GlobMatcher(pattern, caseIgnore);
    }

    public boolean match(String value) {
        return this.matchAll ? value != null : this.doMatch(value);
    }

    private boolean doMatch(String value) {
        this.reset();
        char[] values = value != null ? value.toCharArray() : new char[]{};
        return this.match(0, this.patternChars.length, values, 0, values.length);
    }

    private void reset() {
        this.skipLongerMatchers = false;
    }

    private boolean match(int pattern, int patternLen, char[] stringChars, int string, int stringLen) {
        while (patternLen > 0 && stringLen > 0) {
            switch (this.getPatternChar(pattern)) {
                case '*': {
                    while (patternLen > 1 && this.getPatternChar(pattern + 1) == '*') {
                        ++pattern;
                        --patternLen;
                    }
                    if (patternLen == 1) {
                        return true;
                    }
                    while (stringLen > 0) {
                        if (this.match(pattern + 1, patternLen - 1, stringChars, string, stringLen)) {
                            return true;
                        }
                        if (this.skipLongerMatchers) {
                            return false;
                        }
                        ++string;
                        --stringLen;
                    }
                    this.skipLongerMatchers = true;
                    return false;
                }
                case '?': {
                    ++string;
                    --stringLen;
                    break;
                }
                case '[': {
                    boolean not;
                    --patternLen;
                    boolean bl = not = this.getPatternChar(++pattern) == '^';
                    if (not) {
                        ++pattern;
                        --patternLen;
                    }
                    boolean match = false;
                    while (true) {
                        if (this.getPatternChar(pattern) == '\\' && patternLen >= 2) {
                            --patternLen;
                            if (this.getPatternChar(++pattern) == stringChars[string]) {
                                match = true;
                            }
                        } else {
                            if (this.getPatternChar(pattern) == ']') break;
                            if (patternLen <= 0) {
                                --pattern;
                                ++patternLen;
                                break;
                            }
                            if (patternLen >= 3 && this.getPatternChar(pattern + 1) == '-') {
                                int start = this.getPatternChar(pattern);
                                int end = this.getPatternChar(pattern + 2);
                                int c = stringChars[string];
                                if (start > end) {
                                    int t = start;
                                    start = end;
                                    end = t;
                                }
                                if (this.caseIgnore) {
                                    start = Character.toLowerCase(start);
                                    end = Character.toLowerCase(end);
                                    c = Character.toLowerCase(c);
                                }
                                pattern += 2;
                                patternLen -= 2;
                                if (c >= start && c <= end) {
                                    match = true;
                                }
                            } else if (!this.caseIgnore) {
                                if (this.getPatternChar(pattern) == stringChars[string]) {
                                    match = true;
                                }
                            } else if (Character.toLowerCase(this.getPatternChar(pattern)) == Character.toLowerCase(stringChars[string])) {
                                match = true;
                            }
                        }
                        ++pattern;
                        --patternLen;
                    }
                    if (not) {
                        boolean bl2 = match = !match;
                    }
                    if (!match) {
                        return false;
                    }
                    ++string;
                    --stringLen;
                    break;
                }
                case '\\': {
                    if (patternLen >= 2) {
                        ++pattern;
                        --patternLen;
                    }
                }
                default: {
                    if (!this.caseIgnore ? this.getPatternChar(pattern) != stringChars[string] : Character.toLowerCase(this.getPatternChar(pattern)) != Character.toLowerCase(stringChars[string])) {
                        return false;
                    }
                    ++string;
                    --stringLen;
                }
            }
            ++pattern;
            --patternLen;
            if (stringLen != 0) continue;
            while (patternLen != 0 && this.getPatternChar(pattern) == '*') {
                ++pattern;
                --patternLen;
            }
            break block6;
        }
        return patternLen == 0 && stringLen == 0;
    }

    private char getPatternChar(int i) {
        return this.getChar(this.patternChars, i);
    }

    private char getChar(char[] chars, int i) {
        if (i < 0 || i >= chars.length) {
            return '\u0000';
        }
        return chars[i];
    }
}

