/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.util;

import io.netty.buffer.ByteBuf;
import java.util.Optional;

public class Longs {
    public static final long LOW_32_MASK = 0xFFFFFFFFL;
    protected static final byte[] MIN_LONG_STRING_BYTES = new byte[]{45, 57, 50, 50, 51, 51, 55, 50, 48, 51, 54, 56, 53, 52, 55, 55, 53, 56, 48, 56};
    static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    static final byte[] DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    static final byte[] DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    private Longs() {
    }

    public static boolean isAdditionOverflow(long a, long b) {
        return b > 0L && a > Long.MAX_VALUE - b || b < 0L && a < Long.MIN_VALUE - b;
    }

    public static byte[] toStringBytes(long l) {
        if (l == Long.MIN_VALUE) {
            return MIN_LONG_STRING_BYTES;
        }
        int size = l < 0L ? Longs.stringSize(-l) + 1 : Longs.stringSize(l);
        byte[] result = new byte[size];
        Longs.toBytes(l, size, result);
        return result;
    }

    public static long ceilingPowerOfTwo(long l) {
        return 1L << -Long.numberOfLeadingZeros(l - 1L);
    }

    public static int stringSize(Long l) {
        if (l == Long.MIN_VALUE) {
            return 20;
        }
        return l < 0L ? Longs.negativeStringSize(-l.longValue()) + 1 : Longs.negativeStringSize(l);
    }

    private static int negativeStringSize(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    public static Optional<Long> parseLong(ByteBuf buf) {
        if (buf == null) {
            return Optional.empty();
        }
        buf.readerIndex();
        try {
            Optional<Long> optional = Longs.doParseLong(buf);
            return optional;
        }
        catch (Exception exception) {
            Optional<Long> optional = Optional.empty();
            return optional;
        }
        finally {
            buf.resetReaderIndex();
        }
    }

    public static int getLow(long l) {
        return (int)l;
    }

    public static int getHigh(long l) {
        return (int)(l >> 32);
    }

    public static long merge(int high, int low) {
        return (long)high << 32 | (long)low & 0xFFFFFFFFL;
    }

    private static Optional<Long> doParseLong(ByteBuf buf) {
        int radix = 10;
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int len = buf.readableBytes();
        long limit = -9223372036854775807L;
        if (len > 0) {
            byte firstChar = buf.readByte();
            if (firstChar < 48) {
                if (firstChar == 45) {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != 43) {
                    return Optional.empty();
                }
                if (len == 1) {
                    return Optional.empty();
                }
                ++i;
            }
            long multmin = limit / (long)radix;
            while (i < len) {
                byte ch = i == 0 ? firstChar : buf.readByte();
                ++i;
                int digit = Character.digit(ch, radix);
                if (digit < 0) {
                    return Optional.empty();
                }
                if (result < multmin) {
                    return Optional.empty();
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    return Optional.empty();
                }
                result -= (long)digit;
            }
        } else {
            return Optional.empty();
        }
        return negative ? Optional.of(result) : Optional.of(-result);
    }

    static void toBytes(long i, int index, byte[] buf) {
        int q2;
        int r;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }
}

