/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import kd.bos.xcache.server.util.Fields;

public class MemoryCalculator {
    private static final int DEFAULT_OOP_SIZE = 8;
    private static final int BOOLEAN_SIZE = 1;
    private static final int BYTE_SIZE = 1;
    private static final int CHAR_SIZE = 2;
    private static final int SHORT_SIZE = 2;
    private static final int INT_SIZE = 4;
    private static final int FLOAT_SIZE = 4;
    private static final int LONG_SIZE = 8;
    private static final int DOUBLE_SIZE = 8;
    private static final int OBJECT_HEADER = 12;
    private static final Map<String, Integer> sizeMap = new HashMap<String, Integer>();
    private int oopSize;
    private int size = 12;

    private MemoryCalculator(int oopSize) {
        this.oopSize = oopSize;
    }

    public static int calculate(Class clazz) {
        return MemoryCalculator.calculate(clazz, 8);
    }

    static int calculate(Class clazz, int oopSize) {
        MemoryCalculator calculator = new MemoryCalculator(oopSize);
        Map<String, Field> fields = Fields.getFields(clazz);
        for (Field field : fields.values()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            calculator.add(field.getType().getName());
        }
        return calculator.size();
    }

    private void add(String clazzName) {
        Integer fieldSize = sizeMap.get(clazzName);
        this.size += fieldSize != null ? fieldSize : this.oopSize;
    }

    private int size() {
        return this.size + 7 & 0xFFFFFFF8;
    }

    static {
        sizeMap.put(Byte.TYPE.getName(), 1);
        sizeMap.put(Byte.class.getName(), 1);
        sizeMap.put(Boolean.TYPE.getName(), 1);
        sizeMap.put(Boolean.class.getName(), 1);
        sizeMap.put(Short.TYPE.getName(), 2);
        sizeMap.put(Short.class.getName(), 2);
        sizeMap.put(Character.TYPE.getName(), 2);
        sizeMap.put(Character.class.getName(), 2);
        sizeMap.put(Integer.TYPE.getName(), 4);
        sizeMap.put(Integer.class.getName(), 4);
        sizeMap.put(Long.TYPE.getName(), 8);
        sizeMap.put(Long.class.getName(), 8);
        sizeMap.put(Float.TYPE.getName(), 4);
        sizeMap.put(Float.class.getName(), 4);
        sizeMap.put(Double.TYPE.getName(), 8);
        sizeMap.put(Double.class.getName(), 8);
    }
}

