/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.util;

public class Sizes {
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;

    private Sizes() {
    }

    public static long parse(String size) {
        String dataSize = size.trim().toUpperCase();
        if (dataSize.isEmpty()) {
            return 0L;
        }
        char unit = dataSize.charAt(dataSize.length() - 1);
        switch (unit) {
            case 'K': {
                return Sizes.parsePrefixWithoutUnit(dataSize, 1024L);
            }
            case 'M': {
                return Sizes.parsePrefixWithoutUnit(dataSize, 0x100000L);
            }
            case 'G': {
                return Sizes.parsePrefixWithoutUnit(dataSize, 0x40000000L);
            }
        }
        try {
            return (long)Double.parseDouble(dataSize);
        }
        catch (NumberFormatException e) {
            throw Sizes.illegalSize(size, e);
        }
    }

    private static IllegalArgumentException illegalSize(String size, Throwable cause) {
        return new IllegalArgumentException(String.format("Illegal size format %s", size), cause);
    }

    private static long parsePrefixWithoutUnit(String size, long unit) {
        try {
            return (long)(Double.parseDouble(size.substring(0, size.length() - 1)) * (double)unit);
        }
        catch (NumberFormatException e) {
            throw Sizes.illegalSize(size, e);
        }
    }

    public static String format(long s) {
        if (s == Long.MIN_VALUE) {
            return String.format("%.1fG", (double)s / 1.073741824E9);
        }
        return s >= 0L ? Sizes.doPositiveFormat(s) : String.format("-%s", Sizes.doPositiveFormat(-s));
    }

    private static String doPositiveFormat(long size) {
        if (size < 1024L) {
            return String.format("%s", size);
        }
        if (size < 0x100000L) {
            return Sizes.formatDouble(size, 1024L, "K");
        }
        if (size < 0x40000000L) {
            return Sizes.formatDouble(size, 0x100000L, "M");
        }
        return Sizes.formatDouble(size, 0x40000000L, "G");
    }

    private static String formatDouble(double size, long base, String suffix) {
        return String.format("%.1f%s", size / (double)base, suffix);
    }

    public static long percent(long target, int percent) {
        return target * (long)percent / 100L;
    }
}

