/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.alarm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.io.CharStreams;
import com.sun.net.httpserver.HttpExchange;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.alarm.AlarmConfigManager;
import kd.bos.eye.api.alarm.config.AlarmConfigUtils;
import kd.bos.eye.api.alarm.config.AlarmExtInfo;
import kd.bos.eye.api.alarm.config.AlarmInfo;
import kd.bos.eye.api.alarm.config.action.ActionInfo;
import kd.bos.eye.api.alarm.config.action.SupportAction;
import kd.bos.eye.api.alarm.config.metric.AlarmLevel;
import kd.bos.eye.api.alarm.config.metric.CompareOperater;
import kd.bos.eye.api.alarm.config.metric.MetricInfo;
import kd.bos.eye.api.alarm.db.AlarmConfigDbHelper;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.auth.SessionStore;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.EyeUriQuery;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.mservice.monitor.lang.LangResourceStreamFactory;
import kd.bos.util.JSONUtils;

public class AlarmConfigHandler
extends AbstractHttpHandler {
    public static final String TRUE_STR = "true";
    public static final String FALSE_STR = "false";
    public static final String USER_STR = "user";
    private static final String PLACEHOLDER = "/config/";
    private static final Log LOGGER = LogFactory.getLog(AlarmConfigHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private final String CLASS_SIMPLENAME = this.getClass().getSimpleName();

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        ApiResponse<Object> response;
        block10: {
            response = new ApiResponse<Object>();
            response.setCode(-1);
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            response.setData(map);
            URI uri = exchange.getRequestURI();
            String reqPath = uri.getPath();
            int pos = reqPath.indexOf(PLACEHOLDER);
            String endPoint = reqPath.substring(pos + PLACEHOLDER.length());
            Map<String, String> params = EyeUriQuery.toMap(exchange.getRequestURI().getRawQuery());
            try {
                if ("enableHaWatch".equalsIgnoreCase(endPoint)) {
                    AlarmConfigManager.enableHaWatch();
                    response.setCode(0);
                    break block10;
                }
                if ("disEnableHaWatch".equalsIgnoreCase(endPoint)) {
                    AlarmConfigManager.disEnableHaWatch();
                    response.setCode(0);
                    break block10;
                }
                if ("updateInterval".equalsIgnoreCase(endPoint)) {
                    String intervalStr = params.get("interval");
                    AlarmConfigManager.updateInterval(intervalStr);
                    response.setCode(0);
                    break block10;
                }
                if ("saveAlarm".equals(endPoint)) {
                    this.saveAlarm(exchange, response);
                    break block10;
                }
                if ("delAlarm".equals(endPoint)) {
                    this.delAlarm(exchange, params);
                    response.setCode(0);
                    break block10;
                }
                if ("list".equals(endPoint)) {
                    this.findAlarmConfigPage(exchange, map);
                    response.setCode(0);
                    break block10;
                }
                if ("getDictionary".equals(endPoint)) {
                    this.getMetricsDictionary(map);
                    response.setCode(0);
                    break block10;
                }
                if ("alarmEnable".equals(endPoint)) {
                    boolean enable = AlarmConfigUtils.isEnable();
                    map.put("enable", String.valueOf(enable));
                    response.setCode(0);
                    break block10;
                }
                throw new KDException(BosErrorCode.bOS, new Object[]{"unsupported actionType:" + endPoint});
            }
            catch (Throwable t) {
                LOGGER.error("alarmConfigException:{}", (Object)t.getMessage());
                response.setCode(-1);
                response.setMsg("alarmConfigException:" + t.getMessage());
            }
        }
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private void findAlarmConfigPage(HttpExchange exchange, Map<String, Object> map) throws IOException {
        Map<String, Object> paramMap = this.getBodyToMap(exchange);
        int page = (Integer)paramMap.get("page");
        int size = (Integer)paramMap.get("size");
        String alarmConfigName = (String)paramMap.get("alarmConfigName");
        String updateTime = (String)paramMap.get("updateTime");
        List<Map<String, String>> configMapList = AlarmConfigDbHelper.findConfigPage(alarmConfigName, updateTime, page, size);
        map.put("configList", configMapList);
        int recordTotal = AlarmConfigDbHelper.getConfigTotal(alarmConfigName, updateTime);
        map.put("total", recordTotal);
    }

    private void getMetricsDictionary(Map<String, Object> map) {
        JSONObject tempJSONObj;
        StringBuilder sb = new StringBuilder();
        try (InputStream resourceAsStream = LangResourceStreamFactory.getResourceStream((ClassLoader)AlarmConfigHandler.class.getClassLoader(), (String)"alarm/MetricsDictionary.json");
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(resourceAsStream));
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception e) {
            LOGGER.error("can not read alarm/MetricsDictionary.json!", (Throwable)e);
        }
        String jsonString = sb.toString();
        JSONObject allJSONObject = JSON.parseObject((String)jsonString);
        map.put("tags", allJSONObject.getString("tags"));
        map.put("units", allJSONObject.getString("units"));
        map.put("statistics", allJSONObject.getString("statistics"));
        Map<String, String> tagsMap = this.arrayToMap(allJSONObject.getJSONArray("tags"));
        Map<String, String> unitsMap = this.arrayToMap(allJSONObject.getJSONArray("units"));
        JSONArray metricsJSONArray = allJSONObject.getJSONArray("metrics");
        JSONArray metricTagJSONArray = new JSONArray(metricsJSONArray.size());
        HashSet<String> metricTagCodeSet = new HashSet<String>(metricsJSONArray.size());
        for (int i = 0; i < metricsJSONArray.size(); ++i) {
            JSONObject tempMetricJSONObj = metricsJSONArray.getJSONObject(i);
            tempMetricJSONObj.put("tagName", (Object)tagsMap.get(tempMetricJSONObj.get((Object)"tagCode")));
            tempMetricJSONObj.put("unitName", (Object)unitsMap.get(tempMetricJSONObj.get((Object)"unitCode")));
            if (!metricTagCodeSet.add(tempMetricJSONObj.getString("tagCode"))) continue;
            JSONObject newTagJSONObj = new JSONObject();
            newTagJSONObj.put("code", tempMetricJSONObj.get((Object)"tagCode"));
            newTagJSONObj.put("name", (Object)tagsMap.get(tempMetricJSONObj.get((Object)"tagCode")));
            metricTagJSONArray.add((Object)newTagJSONObj);
        }
        map.put("metrics", JSON.toJSONString((Object)metricsJSONArray));
        map.put("tags", JSON.toJSONString((Object)metricTagJSONArray));
        JSONObject allCompareOperaterEnums = CompareOperater.getAllEnums();
        JSONArray compareOperaterArray = new JSONArray(((CompareOperater[])allCompareOperaterEnums).length);
        for (Object tempEnum : allCompareOperaterEnums) {
            tempJSONObj = new JSONObject();
            tempJSONObj.put("code", (Object)((CompareOperater)((Object)tempEnum)).getCode());
            tempJSONObj.put("desc", (Object)((CompareOperater)((Object)tempEnum)).getDesc());
            compareOperaterArray.add((Object)tempJSONObj);
        }
        map.put("compareOperaters", JSON.toJSONString((Object)compareOperaterArray));
        AlarmLevel[] allAlarmLevelEnums = AlarmLevel.getAllEnums();
        JSONArray alarmLevelArray = new JSONArray(allAlarmLevelEnums.length);
        for (int i = 0; i < allAlarmLevelEnums.length; ++i) {
            Object tempEnum;
            tempEnum = allAlarmLevelEnums[i];
            tempJSONObj = new JSONObject();
            tempJSONObj.put("code", (Object)((AlarmLevel)((Object)tempEnum)).getCode());
            tempJSONObj.put("desc", (Object)((AlarmLevel)((Object)tempEnum)).getDesc());
            alarmLevelArray.add((Object)tempJSONObj);
        }
        map.put("levels", JSON.toJSONString((Object)alarmLevelArray));
    }

    private Map<String, String> arrayToMap(JSONArray jsonArray) {
        HashMap<String, String> resultMap = new HashMap<String, String>(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject tempMetricJSONObj = jsonArray.getJSONObject(i);
            resultMap.put(tempMetricJSONObj.getString("code"), tempMetricJSONObj.getString("name"));
        }
        return resultMap;
    }

    private Map<String, Object> getBodyToMap(HttpExchange exchange) throws IOException {
        InputStreamReader isr = new InputStreamReader(exchange.getRequestBody(), StandardCharsets.UTF_8);
        String query = CharStreams.toString((Readable)isr);
        String str = StringUtils.trimToNull((String)query);
        return (Map)JSON.parseObject((String)str, Map.class);
    }

    private void delAlarm(HttpExchange exchange, Map<String, String> params) throws IOException {
        String idStr = params.get("id");
        if (kd.bos.util.StringUtils.isEmpty((String)idStr)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"the param id can not be null!"});
        }
        long id = Long.parseLong(idStr.trim());
        if (AlarmConfigDbHelper.delAlarmById(id)) {
            String listValue = AlarmConfigUtils.getChangedValue("ha.monitor.config.alarmList");
            AlarmConfigManager.getEyeConfigService().saveConfig("ha.monitor.config.alarmList", listValue);
            OPLOGGER.opLog(exchange, OpType.DELETE, LangRes.get((String)"AlarmConfigHandler_5", (String)"\u544a\u8b66\u7b56\u7565", (Object[])new Object[0]), LangRes.get((String)"AlarmConfigHandler_7", (String)"\u5220\u9664\u544a\u8b66\u7b56\u7565\u6570\u636e,\u4e3b\u952eid:", (Object[])new Object[0]) + id);
        }
    }

    private void saveAlarm(HttpExchange exchange, ApiResponse<Object> response) throws IOException {
        Object des;
        InputStreamReader isr = new InputStreamReader(exchange.getRequestBody(), StandardCharsets.UTF_8);
        String query = CharStreams.toString((Readable)isr);
        String paramStr = StringUtils.trimToNull((String)query);
        Map paramMap = (Map)JSONUtils.cast((String)paramStr, Map.class, (boolean)true);
        AlarmInfo alarmInfo = new AlarmInfo();
        String name = String.valueOf(paramMap.get("name")).trim();
        this.checkParamNull("name", name);
        alarmInfo.setName(name);
        boolean isAdd = true;
        String idStr = (String)paramMap.get("id");
        if (kd.bos.util.StringUtils.isNotEmpty((String)idStr)) {
            long id = Long.parseLong(idStr.trim());
            if (AlarmConfigDbHelper.getAlarmInfoById(id) == null) {
                throw new KDException(BosErrorCode.bOS, new Object[]{"update alarm error: the alarm is not exist where id = " + id});
            }
            alarmInfo.setId(id);
            isAdd = false;
        } else {
            alarmInfo.setId(ID.genLongId());
            AlarmInfo alarmInfoFromDb = AlarmConfigDbHelper.getAlarmInfoByName(name);
            if (alarmInfoFromDb != null) {
                response.setMsg(LangRes.get((String)(this.CLASS_SIMPLENAME + "_3"), (String)"Name already exists", (Object[])new Object[0]));
                return;
            }
        }
        String actionEnable = String.valueOf(paramMap.get("actionEnabled")).trim();
        String isAndMetric = String.valueOf(paramMap.get("isAndMetric")).trim();
        String metrics = JSONUtils.toString(paramMap.get("metrics")).trim();
        this.checkParamNull("actionEnabled", actionEnable);
        this.checkParamNull("isAndMetric", isAndMetric);
        this.checkParamNull("metrics", metrics);
        alarmInfo.setActionEnabled(TRUE_STR.equals(actionEnable));
        alarmInfo.setAndMetric(TRUE_STR.equals(isAndMetric));
        List metricInfoList = (List)JSONUtils.cast((String)metrics, (boolean)true, List.class, (Class[])new Class[]{MetricInfo.class});
        alarmInfo.addMetricInfoList(metricInfoList);
        if (paramMap.get("actions") != null) {
            String actions = JSONUtils.toString(paramMap.get("actions")).trim();
            List actionInfoList = (List)JSONUtils.cast((String)actions, (boolean)true, List.class, (Class[])new Class[]{ActionInfo.class});
            for (ActionInfo actionInfo : actionInfoList) {
                String phones;
                String actionType = actionInfo.getActionType();
                JSONObject tempConfigJSONObj = JSON.parseObject((String)actionInfo.getConfig());
                JSONObject resultJSONObj = new JSONObject();
                if (actionType.equals(SupportAction.SMS.getType())) {
                    phones = tempConfigJSONObj.getString("phone");
                    String regex = "^[0-9;]*$";
                    Pattern pattern = Pattern.compile(regex);
                    Matcher matcher = pattern.matcher(phones);
                    if (!matcher.matches()) {
                        response.setMsg(LangRes.get((String)(this.CLASS_SIMPLENAME + "_10"), (String)"Invalid Phone Number Format, Please Check (Multiple Numbers Should be Separated by \";\")", (Object[])new Object[0]));
                        return;
                    }
                    String[] phoneArray = phones.split(";");
                    ArrayList<String> phoneList = new ArrayList<String>();
                    for (String tempPhone : phoneArray) {
                        if (!kd.bos.util.StringUtils.isNotEmpty((String)tempPhone)) continue;
                        boolean isPhone = StringUtils.isPhoneNumberValid((String)tempPhone);
                        if (!isPhone) {
                            response.setMsg(LangRes.get((String)(this.CLASS_SIMPLENAME + "_10"), (String)"Invalid Phone Number Format, Please Check (Multiple Numbers Should be Separated by \";\")", (Object[])new Object[0]));
                            return;
                        }
                        phoneList.add(tempPhone);
                    }
                    resultJSONObj.put("phone", (Object)phoneList.stream().collect(Collectors.joining(";")));
                    actionInfo.setConfig(JSON.toJSONString((Object)resultJSONObj));
                    continue;
                }
                if (!actionType.equals(SupportAction.EMAIL.getType())) continue;
                phones = tempConfigJSONObj.getString("mail");
                String[] emailArray = phones.split(",");
                ArrayList<String> emailList = new ArrayList<String>();
                for (String tempEmail : emailArray) {
                    if (!kd.bos.util.StringUtils.isNotEmpty((String)tempEmail)) continue;
                    boolean isEmail = StringUtils.isEmail((String)tempEmail);
                    if (!isEmail) {
                        response.setMsg(LangRes.get((String)(this.CLASS_SIMPLENAME + "_1"), (String)"Email format is incorrect, please check", (Object[])new Object[0]));
                        return;
                    }
                    emailList.add(tempEmail);
                }
                resultJSONObj.put("mail", (Object)emailList.stream().collect(Collectors.joining(",")));
                actionInfo.setConfig(JSON.toJSONString((Object)resultJSONObj));
            }
            alarmInfo.addActionInfoList(actionInfoList);
        }
        if (paramMap.get("extjson") != null) {
            String extJson = JSONUtils.toString(paramMap.get("extjson")).trim();
            AlarmExtInfo extInfo = (AlarmExtInfo)JSONUtils.cast((String)extJson, (boolean)true, AlarmExtInfo.class, (Class[])new Class[0]);
            alarmInfo.setAlarmExtInfo(extInfo);
        }
        if ((des = paramMap.get("des")) != null && kd.bos.util.StringUtils.isNotEmpty((String)((String)des))) {
            alarmInfo.setDes(String.valueOf(des));
        } else {
            alarmInfo.setDes(" ");
        }
        Map<String, String> userInfo = SessionStore.get().get(EyeAuther.getToken(exchange));
        alarmInfo.setUpdateUser(userInfo.get(USER_STR));
        alarmInfo.setUpdateTime(LocalDateTime.now());
        if (AlarmConfigDbHelper.saveAlarm(alarmInfo)) {
            String listValue = AlarmConfigUtils.getChangedValue("ha.monitor.config.alarmList");
            AlarmConfigManager.getEyeConfigService().saveConfig("ha.monitor.config.alarmList", listValue);
        }
        response.setCode(0);
        if (isAdd) {
            OPLOGGER.opLog(exchange, OpType.ADD, LangRes.get((String)"AlarmConfigHandler_5", (String)"\u544a\u8b66\u7b56\u7565", (Object[])new Object[0]), LangRes.get((String)"AlarmConfigHandler_8", (String)"\u65b0\u589e\u544a\u8b66\u7b56\u7565,\u540d\u79f0:", (Object[])new Object[0]) + name);
        } else {
            OPLOGGER.opLog(exchange, OpType.EDIT, LangRes.get((String)"AlarmConfigHandler_5", (String)"\u544a\u8b66\u7b56\u7565", (Object[])new Object[0]), LangRes.get((String)"AlarmConfigHandler_9", (String)"\u4fee\u6539\u544a\u8b66\u7b56\u7565,\u540d\u79f0:", (Object[])new Object[0]) + name);
        }
    }

    private void checkParamNull(String paramName, String value) {
        if (kd.bos.util.StringUtils.isEmpty((String)value)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"the param of" + paramName + "can not be null!"});
        }
    }
}

