/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.alarm;

import java.io.IOException;
import java.io.StringReader;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.alarm.config.AlarmConfigListener;
import kd.bos.eye.api.alarm.config.AlarmConfigUtils;
import kd.bos.eye.api.alarm.config.AlarmInfo;
import kd.bos.eye.api.alarm.config.AlarmListParse;
import kd.bos.eye.api.alarm.config.action.ActionInfo;
import kd.bos.eye.api.alarm.config.action.SupportAction;
import kd.bos.eye.api.alarm.db.AlarmConfigDbHelper;
import kd.bos.eye.api.config.manager.UnifiedConfigHookService;
import kd.bos.eye.api.config.manager.UnifiedConfigManager;
import kd.bos.eye.config.custom.ConfigDbHelper;
import kd.bos.eye.config.custom.ConfigModule;
import kd.bos.eye.config.service.EyeConfigChangeListener;
import kd.bos.eye.config.service.EyeConfigService;
import kd.bos.eye.config.service.EyeConfigServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.StringUtils;

public class AlarmConfigManager {
    private static final String TRUE_STR = "true";
    private static final String FALSE_STR = "false";
    private static final String USER_STR = "user";
    private static final Log log = LogFactory.getLog(AlarmConfigManager.class);
    private static final String[] array = new String[]{"ha.mc.config.init", "ha.monitor.config.enable", "ha.monitor.config.interval", "ha.monitor.config.alarmList"};
    private static final AlarmConfigChangeListener LISTENER = new AlarmConfigChangeListener();
    private static EyeConfigService eyeConfigService;

    public static void registerEyeConfigService() {
        eyeConfigService = EyeConfigServiceFactory.getEyeConfigService(AlarmConfigUtils.getPath(), scene -> {
            if ("initDataFromDB".equals(scene)) {
                AlarmConfigHook alarmConfigHook = new AlarmConfigHook();
                UnifiedConfigManager.registHookService(ConfigModule.ALARM_CONFIG.getNumber(), "ha.monitor.config.enable", alarmConfigHook);
                UnifiedConfigManager.registHookService(ConfigModule.ALARM_CONFIG.getNumber(), "ha.monitor.config.interval", alarmConfigHook);
                UnifiedConfigManager.registHookService(ConfigModule.ALARM_CONFIG.getNumber(), "ha.mc.config.init", alarmConfigHook);
                return AlarmConfigManager.getAlarmConfigMap();
            }
            if ("schedulePullDataFromDB".equals(scene)) {
                HashMap<String, String> map = new HashMap<String, String>(1);
                try {
                    map.put("ha.monitor.config.alarmList", AlarmConfigManager.getChangedValue("ha.monitor.config.alarmList"));
                }
                catch (IOException e) {
                    log.warn("AlarmConfigManager schedule getAlarmList exception:", (Throwable)e);
                }
                return map;
            }
            return null;
        }, LISTENER);
    }

    public static EyeConfigService getEyeConfigService() {
        return eyeConfigService;
    }

    private static Map<String, String> getAlarmConfigMap() {
        HashMap<String, String> map = new HashMap<String, String>(4);
        try {
            for (String changeConfigKey : array) {
                map.put(changeConfigKey, AlarmConfigManager.getChangedValue(changeConfigKey));
            }
        }
        catch (Exception e) {
            log.warn("AlarmConfigManager getAllAlarmConfigMap exception:", (Throwable)e);
        }
        return map;
    }

    public static String getChangedValue(String changeConfigKey) throws IOException {
        String value = null;
        if ("ha.monitor.config.enable".equals(changeConfigKey) || "ha.monitor.config.interval".equals(changeConfigKey) || "ha.mc.config.init".equals(changeConfigKey)) {
            value = ConfigDbHelper.getValueByKeyFromDB(changeConfigKey);
        } else if ("ha.monitor.config.alarmList".equals(changeConfigKey)) {
            List<AlarmInfo> alarmInfos = AlarmConfigDbHelper.getAlarmInfos();
            if (alarmInfos != null && !alarmInfos.isEmpty()) {
                for (AlarmInfo alarmInfo : alarmInfos) {
                    alarmInfo.addActionInfo(new ActionInfo("MonitorRecord", "\u544a\u8b66\u8bb0\u5f55"));
                    alarmInfo.addActionInfo(new ActionInfo(SupportAction.LOGGER.getType(), SupportAction.LOGGER.getName()));
                }
                value = AlarmListParse.parseAlarmInfosToJson(alarmInfos);
            }
        } else {
            throw new KDException(BosErrorCode.bOS, new Object[]{"unsupported changeConfigKey:" + changeConfigKey});
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    protected static void updateInterval(String intervalStr) throws IOException {
        if (StringUtils.isEmpty((String)intervalStr)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"the param interval can not be null!"});
        }
        int interval = Integer.parseInt(intervalStr.trim());
        if (AlarmConfigDbHelper.saveKeyValue("ha.monitor.config.interval", String.valueOf(interval))) {
            String value = AlarmConfigUtils.getChangedValue("ha.monitor.config.interval");
            AlarmConfigManager.getEyeConfigService().saveConfig("ha.monitor.config.interval", value);
        }
    }

    protected static void disEnableHaWatch() throws IOException {
        if (TRUE_STR.equals(ConfigDbHelper.getValueByKey("ha.monitor.config.enable")) && AlarmConfigDbHelper.saveKeyValue("ha.monitor.config.enable", FALSE_STR)) {
            String enableValue = AlarmConfigUtils.getChangedValue("ha.monitor.config.enable");
            AlarmConfigManager.getEyeConfigService().saveConfig("ha.monitor.config.enable", enableValue);
        }
    }

    protected static void enableHaWatch() throws IOException {
        if (!TRUE_STR.equals(ConfigDbHelper.getValueByKey("ha.mc.config.init"))) {
            AlarmConfigManager.initSaveMCConfig();
            if (AlarmConfigDbHelper.saveKeyValue("ha.mc.config.init", TRUE_STR)) {
                String initValue = AlarmConfigUtils.getChangedValue("ha.mc.config.init");
                AlarmConfigManager.getEyeConfigService().saveConfig("ha.mc.config.init", initValue);
                String listValue = AlarmConfigUtils.getChangedValue("ha.monitor.config.alarmList");
                AlarmConfigManager.getEyeConfigService().saveConfig("ha.monitor.config.alarmList", listValue);
            }
        }
        if (!TRUE_STR.equals(ConfigDbHelper.getValueByKey("ha.monitor.config.enable")) && AlarmConfigDbHelper.saveKeyValue("ha.monitor.config.enable", TRUE_STR)) {
            String enableValue = AlarmConfigUtils.getChangedValue("ha.monitor.config.enable");
            AlarmConfigManager.getEyeConfigService().saveConfig("ha.monitor.config.enable", enableValue);
        }
    }

    private static void initSaveMCConfig() {
        try {
            String config = System.getProperty("ha.watch.monitor");
            if (config == null) {
                return;
            }
            Properties props = new Properties();
            props.load(new StringReader(config));
            boolean enabled = Boolean.parseBoolean(props.getProperty("enable", FALSE_STR));
            if (enabled) {
                String alarmListJson;
                if (AlarmConfigDbHelper.saveKeyValue("ha.monitor.config.interval", props.getProperty("interval", "15"))) {
                    String intervalValue = AlarmConfigUtils.getChangedValue("ha.monitor.config.interval");
                    AlarmConfigManager.getEyeConfigService().saveConfig("ha.monitor.config.interval", intervalValue);
                }
                if (StringUtils.isNotEmpty((String)(alarmListJson = System.getProperty("ha.watch.alarmlist")))) {
                    List<AlarmInfo> alarmInfos = AlarmListParse.parseJsonToAlarmInfos(alarmListJson);
                    for (AlarmInfo alarmInfo : alarmInfos) {
                        alarmInfo.setUpdateUser("");
                        alarmInfo.setUpdateTime(LocalDateTime.now());
                        AlarmConfigDbHelper.saveAlarm(alarmInfo);
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDException(BosErrorCode.bOS, "init mc config error:" + ex.getMessage(), (Throwable)ex);
        }
    }

    private static class AlarmConfigHook
    implements UnifiedConfigHookService {
        private AlarmConfigHook() {
        }

        @Override
        public String beforeSave(String key, UnifiedConfigManager.ConfigParam configParam) throws Exception {
            String value = configParam.getValue();
            if (key.equals("ha.monitor.config.enable")) {
                if (!value.equals(AlarmConfigManager.TRUE_STR) && !value.equals(AlarmConfigManager.FALSE_STR)) {
                    return LangRes.get((String)"AlarmConfigHook_0", (String)"\u544a\u8b66\u5f00\u5173\u53ea\u80fd\u586btrue\u6216\u8005false", (Object[])new Object[0]);
                }
                if (Boolean.parseBoolean(value)) {
                    AlarmConfigManager.enableHaWatch();
                } else {
                    AlarmConfigManager.disEnableHaWatch();
                }
            } else if (key.equals("ha.monitor.config.interval")) {
                try {
                    int interval = Integer.parseInt(value.trim());
                    if (interval < 15) {
                        return LangRes.get((String)"AlarmConfigHook_1", (String)"\u544a\u8b66\u5237\u65b0\u9891\u7387\uff08\u5355\u4f4d\u79d2\uff09\u6700\u5c0f\u652f\u630115\u79d2", (Object[])new Object[0]);
                    }
                    if (interval > 180) {
                        return LangRes.get((String)"AlarmConfigHook_2", (String)"\u544a\u8b66\u5237\u65b0\u9891\u7387\uff08\u5355\u4f4d\u79d2\uff09\u6700\u5927\u652f\u63013\u5206\u949f", (Object[])new Object[0]);
                    }
                    AlarmConfigManager.updateInterval(value);
                }
                catch (NumberFormatException ex) {
                    return LangRes.get((String)"AlarmConfigHook_3", (String)"\u544a\u8b66\u5237\u65b0\u9891\u7387\uff08\u5355\u4f4d\u79d2\uff09\u4ec5\u652f\u630115\u79d2\u81f3180\u79d2", (Object[])new Object[0]);
                }
            } else if (key.equals("ha.mc.config.init")) {
                return LangRes.get((String)"AlarmConfigHook_4", (String)"\u544a\u8b66\u65e7\u914d\u7f6e\u521d\u59cb\u5316\u7981\u6b62\u4fee\u6539", (Object[])new Object[0]);
            }
            return null;
        }

        @Override
        public void afterSave(String key, UnifiedConfigManager.ConfigParam configParam) throws Exception {
            for (AlarmConfigListener alarmConfigListener : AlarmConfigUtils.getListenerList()) {
                alarmConfigListener.configChanged(key, configParam.getValue());
            }
        }
    }

    private static final class AlarmConfigChangeListener
    implements EyeConfigChangeListener {
        private AlarmConfigChangeListener() {
        }

        @Override
        public void configUpdate(String key, String value) {
            for (AlarmConfigListener alarmConfigListener : AlarmConfigUtils.getListenerList()) {
                alarmConfigListener.configChanged(key, value);
            }
        }
    }
}

