/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.alarm.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.alarm.AlarmConfigManager;
import kd.bos.eye.api.alarm.config.AlarmConfigListener;
import kd.bos.eye.api.alarm.config.AlarmInfo;
import kd.bos.eye.api.alarm.config.AlarmListParse;
import kd.bos.eye.api.alarm.config.action.ActionInfo;
import kd.bos.eye.api.alarm.config.action.SupportAction;
import kd.bos.eye.api.alarm.db.AlarmConfigDbHelper;
import kd.bos.eye.config.custom.ConfigDbHelper;
import kd.bos.instance.Instance;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.StringUtils;

public class AlarmConfigUtils {
    public static final String TRUE_STR = "true";
    private static final String PATH_SUFFIX = "/runtime/monitor/config/haMonitorConfig";
    private static final List<AlarmConfigListener> listenerList = new ArrayList<AlarmConfigListener>();

    public static void addAlarmConfigListener(AlarmConfigListener alarmConfigListener) {
        listenerList.add(alarmConfigListener);
    }

    public static List<AlarmConfigListener> getListenerList() {
        return listenerList;
    }

    public static boolean isInitialized() {
        return TRUE_STR.equals(AlarmConfigUtils.getNodeValue("ha.mc.config.init"));
    }

    public static boolean isEnable() {
        return TRUE_STR.equals(AlarmConfigUtils.getNodeValue("ha.monitor.config.enable"));
    }

    public static int getIntervalSecondes() {
        return AlarmConfigUtils.getInterval(AlarmConfigUtils.getNodeValue("ha.monitor.config.interval"));
    }

    public static String getAlarmListJson() {
        return AlarmConfigUtils.getNodeValue("ha.monitor.config.alarmList");
    }

    public static String getActionListJson() {
        return "";
    }

    public static String getChangedValue(String changeConfigKey) throws IOException {
        String value = null;
        if ("ha.monitor.config.enable".equals(changeConfigKey) || "ha.monitor.config.interval".equals(changeConfigKey) || "ha.mc.config.init".equals(changeConfigKey)) {
            value = ConfigDbHelper.getValueByKeyFromDB(changeConfigKey);
        } else if ("ha.monitor.config.alarmList".equals(changeConfigKey)) {
            List<AlarmInfo> alarmInfos = AlarmConfigDbHelper.getAlarmInfos();
            if (alarmInfos != null && !alarmInfos.isEmpty()) {
                for (AlarmInfo alarmInfo : alarmInfos) {
                    alarmInfo.addActionInfo(new ActionInfo("MonitorRecord", LangRes.get((String)"AlarmConfigUtils_Alarm_Log", (String)"Alarm Log", (Object[])new Object[0])));
                    alarmInfo.addActionInfo(new ActionInfo(SupportAction.LOGGER.getType(), SupportAction.LOGGER.getName()));
                }
                value = AlarmListParse.parseAlarmInfosToJson(alarmInfos);
            }
        } else {
            throw new KDException(BosErrorCode.bOS, new Object[]{"unsupported changeConfigKey:" + changeConfigKey});
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public static String getRegion() {
        return "gov.zk.url";
    }

    public static String getPath() {
        return Instance.getClusterName() + PATH_SUFFIX;
    }

    @Deprecated
    public static String getZKDirector() {
        return Instance.getClusterName() + PATH_SUFFIX;
    }

    private static int getInterval(String intervalStr) {
        int interval;
        if (StringUtils.isEmpty((String)intervalStr)) {
            intervalStr = "15";
        }
        if ((interval = Integer.parseInt(intervalStr = intervalStr.trim())) <= 10) {
            interval = 10;
        }
        return interval;
    }

    private static String getNodeValue(String nodeName) {
        try {
            return AlarmConfigManager.getChangedValue(nodeName);
        }
        catch (IOException e) {
            throw new KDException(BosErrorCode.bOS, new Object[]{e});
        }
    }
}

