/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.alarm.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.alarm.config.AlarmExtInfo;
import kd.bos.eye.api.alarm.config.AlarmInfo;
import kd.bos.eye.api.alarm.config.action.ActionInfo;
import kd.bos.eye.api.alarm.config.metric.AlarmLevel;
import kd.bos.eye.api.alarm.config.metric.CompareOperater;
import kd.bos.eye.api.alarm.config.metric.MetricInfo;
import kd.bos.eye.api.alarm.config.metric.MetricStatistic;
import kd.bos.id.ID;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class AlarmListParse {
    public static String parseAlarmInfosToJson(List<AlarmInfo> alarmInfos) throws IOException {
        if (alarmInfos == null || alarmInfos.isEmpty()) {
            return "";
        }
        ArrayList mapList = new ArrayList();
        for (AlarmInfo alarmInfo : alarmInfos) {
            String name = alarmInfo.getName();
            boolean actionEnabled = alarmInfo.isActionEnabled();
            AlarmExtInfo alarmExtInfo = alarmInfo.getAlarmExtInfo();
            int silentPeriod = alarmExtInfo.getSilentPeriod();
            String timeFm = alarmExtInfo.getTimeFm();
            String timeTo = alarmExtInfo.getTimeTo();
            for (MetricInfo metricInfo : alarmInfo.getMetricInfoList()) {
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                map.put("name", name);
                map.put("category", metricInfo.getCategory());
                map.put("metricName", metricInfo.getMetricName());
                map.put("period", metricInfo.getPeriod());
                map.put("evaluationPeriods", metricInfo.getEvaluationPeriods());
                map.put("timeFm", timeFm);
                map.put("timeTo", timeTo);
                map.put("silentPeriod", silentPeriod);
                map.put("statistic", (Object)metricInfo.getStatistic());
                map.put("comparisonOperator", (Object)metricInfo.getComparisonOperator());
                map.put("threshold", metricInfo.getThreshold());
                map.put("unit", metricInfo.getUnit());
                map.put("actionEnabled", actionEnabled);
                map.put("actions", alarmInfo.getActionInfoList());
                mapList.add(map);
            }
        }
        return JSONUtils.toString(mapList);
    }

    public static List<AlarmInfo> parseJsonToAlarmInfos(String alarmListJson) throws IOException {
        ArrayList<AlarmInfo> lstAlarms = new ArrayList<AlarmInfo>(16);
        String newAlarmJson = alarmListJson.replace("slientPeriod", "silentPeriod");
        List mapList = (List)JSONUtils.cast((String)newAlarmJson, List.class, (Class[])new Class[]{Map.class});
        HashSet nameSet = new HashSet(1);
        for (Map map : mapList) {
            String actionListJson;
            List actionInfos;
            List actionList;
            AlarmInfo alarmInfo = new AlarmInfo();
            Object id = map.get("id");
            if (id == null) {
                id = ID.genLongId();
            }
            alarmInfo.setId((Long)id);
            String name = String.valueOf(map.get("name"));
            if (StringUtils.isEmpty((String)name) || nameSet.contains(name)) {
                name = "alarmName" + id;
            }
            alarmInfo.setName(name);
            Object des = map.get("des");
            if (des != null) {
                alarmInfo.setDes(String.valueOf(des));
            }
            alarmInfo.setActionEnabled((Boolean)map.get("actionEnabled"));
            AlarmExtInfo alarmExtInfo = new AlarmExtInfo();
            alarmExtInfo.setSilentPeriod((Integer)map.get("silentPeriod"));
            alarmExtInfo.setTimeFm((String)map.get("timeFm"));
            alarmExtInfo.setTimeTo((String)map.get("timeTo"));
            alarmInfo.setAlarmExtInfo(alarmExtInfo);
            MetricInfo metricInfo = new MetricInfo();
            metricInfo.setMetricName((String)map.get("metricName"));
            metricInfo.setUnit((String)map.get("unit"));
            metricInfo.setCategory((String)map.get("category"));
            metricInfo.setPeriod((Integer)map.get("period"));
            metricInfo.setEvaluationPeriods((Integer)map.get("evaluationPeriods"));
            metricInfo.setThreshold(((Integer)map.get("threshold")).intValue());
            metricInfo.setComparisonOperator(CompareOperater.valueOf((String)map.get("comparisonOperator")));
            metricInfo.setStatistic(MetricStatistic.valueOf((String)map.get("statistic")));
            metricInfo.setLevel(AlarmLevel.LOW.getDesc());
            alarmInfo.addMetricInfo(metricInfo);
            List actionRefs = (List)map.get("actionRefs");
            if (actionRefs != null && !actionRefs.isEmpty()) {
                String actionListJson2 = System.getProperty("ha.watch.actionlist");
                List lstActionRef = null;
                if (StringUtils.isNotEmpty((String)actionListJson2)) {
                    lstActionRef = (List)JSONUtils.cast((String)actionListJson2, (boolean)true, List.class, (Class[])new Class[]{ActionInfo.class});
                }
                for (String actionRefName : actionRefs) {
                    ActionInfo actionRefInfo = AlarmListParse.getActionRefByActionType(lstActionRef, actionRefName);
                    if (actionRefInfo == null) {
                        throw new RuntimeException("Cannot found action:" + actionRefName + " in actionlist");
                    }
                    alarmInfo.addActionInfo(actionRefInfo);
                }
            }
            if ((actionList = (List)map.get("actions")) != null && !actionList.isEmpty() && (actionInfos = (List)JSONUtils.cast((String)(actionListJson = JSONUtils.toString((Object)actionList)), (boolean)true, List.class, (Class[])new Class[]{ActionInfo.class})) != null && !actionInfos.isEmpty()) {
                alarmInfo.addActionInfoList(actionInfos);
            }
            lstAlarms.add(alarmInfo);
        }
        return lstAlarms;
    }

    private static ActionInfo getActionRefByActionType(List<ActionInfo> lstActionRef, String actionType) {
        if (lstActionRef == null || lstActionRef.size() == 0) {
            return null;
        }
        for (ActionInfo action : lstActionRef) {
            if (!actionType.equals(action.getActionType())) continue;
            return action;
        }
        return null;
    }
}

