/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.alarm.db;

import java.io.IOException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.alarm.config.AlarmInfo;
import kd.bos.eye.api.alarm.config.metric.MetricInfo;
import kd.bos.eye.api.alarm.db.AlarmBaseDbHelper;
import kd.bos.eye.api.alarm.db.AlarmConfigDbHelper;
import kd.bos.eye.api.alarm.db.DBFields;
import kd.bos.eye.api.alarm.record.RecordInfo;
import kd.bos.eye.api.alarm.record.enums.RecordState;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.id.ID;
import kd.bos.instance.Instance;
import kd.bos.login.utils.DateUtils;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class AlarmRecordDbHelper
extends AlarmBaseDbHelper {
    private static final String ONE_STR = "1";
    private static final DateTimeFormatter FRONT_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static List<Map<String, String>> findRecordPage(String alarmConfigName, String state, String alarmTime, int page, int size) {
        ArrayList<Map<String, String>> resultList = null;
        ArrayList<Object> queryList = new ArrayList<Object>(10);
        String[] filterFields = null;
        if (StringUtils.isNotEmpty((String)state)) {
            filterFields = new String[]{"fstate"};
            queryList.add(state);
        }
        StringBuilder sb = new StringBuilder();
        String selectSql = AlarmRecordDbHelper.buildTopQuerySql("T_MONITOR_ALARM_RECORD", DBFields.AlarmRecord.getAllFields(), filterFields, page, size);
        sb.append(selectSql);
        if (StringUtils.isNotEmpty((String)alarmConfigName)) {
            if (queryList.size() == 0) {
                sb.append(" where ");
            } else {
                sb.append(" and ");
            }
            sb.append("falarmname like ? ");
            if (AlarmRecordDbHelper.needContainEscape()) {
                sb.append(" escape '\\' ");
            }
            alarmConfigName = alarmConfigName.replace("%", "\\%");
            queryList.add("%" + alarmConfigName + "%");
        }
        if (StringUtils.isNotEmpty((String)alarmTime)) {
            if (queryList.size() == 0) {
                sb.append(" where ");
            } else {
                sb.append(" and ");
            }
            sb.append("fstarttime >=? ");
            queryList.add(Timestamp.valueOf(LocalDateTime.parse(alarmTime, FRONT_FORMATTER)));
        }
        sb.append(" order by fstarttime desc");
        try {
            DBRequest dbRequest = new DBRequest();
            dbRequest.setQueryRequest(new DBRequest.QueryRequest(sb.toString(), queryList));
            List retunList = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            resultList = new ArrayList<Map<String, String>>(retunList.size());
            for (Result row : retunList) {
                HashMap<String, String> tempMap = new HashMap<String, String>();
                tempMap.put("id", row.getString("fid"));
                tempMap.put("appName", row.getString("fappname"));
                tempMap.put("ip", row.getString("fip"));
                tempMap.put("alarmName", row.getString("falarmname"));
                tempMap.put("metricName", row.getString("fmetricname"));
                tempMap.put("state", row.getString("fstate"));
                tempMap.put("alarmMsg", row.getString("falarmmsg"));
                tempMap.put("startTimeString", AlarmRecordDbHelper.dateTimeFormat(row.getString("fstarttime")));
                tempMap.put("lastTimeString", AlarmRecordDbHelper.dateTimeFormat(row.getString("flasttime")));
                tempMap.put("restoreTimeString", AlarmRecordDbHelper.dateTimeFormat(row.getString("frestoretime")));
                tempMap.put("alarmId", row.getString("falarmid"));
                tempMap.put("totalNumber", row.getString("ftotalnumber"));
                tempMap.put("duration", row.getString("fduration"));
                tempMap.put("level", row.getString("flevel"));
                resultList.add(tempMap);
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.paramError, new Object[]{e});
        }
        return resultList;
    }

    private static String dateTimeFormat(String dateTimeString) {
        if (StringUtils.isEmpty((String)dateTimeString)) {
            return "";
        }
        return DateUtils.formatDate((Date)DateUtils.parseDateTime((String)dateTimeString, (String)"yyyy-MM-dd HH:mm:ss"), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"});
    }

    public static int getRecordTotal(String alarmConfigName, String state, String alarmTime) {
        ArrayList<Object> queryList = new ArrayList<Object>(10);
        String[] filterFields = null;
        if (StringUtils.isNotEmpty((String)state)) {
            filterFields = new String[]{"fstate"};
            queryList.add(state);
        }
        StringBuilder sb = new StringBuilder();
        String selectSql = AlarmRecordDbHelper.buildTotalSql("T_MONITOR_ALARM_RECORD", filterFields);
        sb.append(selectSql);
        if (StringUtils.isNotEmpty((String)alarmConfigName)) {
            if (queryList.size() == 0) {
                sb.append(" where ");
            } else {
                sb.append(" and ");
            }
            sb.append("falarmname like ? ");
            if (AlarmRecordDbHelper.needContainEscape()) {
                sb.append(" escape '\\' ");
            }
            alarmConfigName = alarmConfigName.replace("%", "\\%");
            queryList.add("%" + alarmConfigName + "%");
        }
        if (StringUtils.isNotEmpty((String)alarmTime)) {
            if (queryList.size() == 0) {
                sb.append(" where ");
            } else {
                sb.append(" and ");
            }
            sb.append("fstarttime >=? ");
            queryList.add(Timestamp.valueOf(LocalDateTime.parse(alarmTime, FRONT_FORMATTER)));
        }
        try {
            DBRequest dbRequest = new DBRequest();
            dbRequest.setQueryRequest(new DBRequest.QueryRequest(sb.toString(), queryList));
            List retunList = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            return Integer.parseInt(((Result)retunList.get(0)).getString("total"));
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.paramError, new Object[]{e});
        }
    }

    public static RecordInfo getRecordInfo(long id) throws IOException {
        ArrayList queryList = new ArrayList(1);
        Collections.addAll(queryList, id);
        DBRequest dbRequest = new DBRequest();
        String querySql = AlarmRecordDbHelper.buildQuerySql("T_MONITOR_ALARM_RECORD", DBFields.AlarmRecord.getAllFields(), new String[]{"fid"});
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
        List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        if (!results.isEmpty()) {
            return AlarmRecordDbHelper.resultToRecordInfo((Result)results.get(0));
        }
        return null;
    }

    public static RecordInfo getRecordInfo(String ip, String alarmName, String metricName) throws IOException {
        ArrayList queryList = new ArrayList(1);
        Collections.addAll(queryList, ip, alarmName, metricName);
        DBRequest dbRequest = new DBRequest();
        String querySql = AlarmRecordDbHelper.buildQuerySql("T_MONITOR_ALARM_RECORD", DBFields.AlarmRecord.getAllFields(), new String[]{"fip", "falarmname", "fmetricname"});
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
        List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        if (!results.isEmpty()) {
            return AlarmRecordDbHelper.resultToRecordInfo((Result)results.get(0));
        }
        return null;
    }

    public static RecordInfo getRecordInfo(String ip, long alarmID, String metricName) throws IOException {
        ArrayList queryList = new ArrayList(1);
        Collections.addAll(queryList, ip, alarmID, metricName);
        DBRequest dbRequest = new DBRequest();
        String querySql = AlarmRecordDbHelper.buildQuerySql("T_MONITOR_ALARM_RECORD", DBFields.AlarmRecord.getAllFields(), new String[]{"fip", "falarmid", "fmetricname"});
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
        List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        if (!results.isEmpty()) {
            return AlarmRecordDbHelper.resultToRecordInfo((Result)results.get(0));
        }
        return null;
    }

    public static RecordInfo resultToRecordInfo(Result result) throws IOException {
        RecordInfo recordInfo = new RecordInfo();
        recordInfo.setId(Long.parseLong(result.getString("fid")));
        recordInfo.setAppName(result.getString("fappname"));
        recordInfo.setIp(result.getString("fip"));
        recordInfo.setAlarmId(Long.parseLong(result.getString("falarmid")));
        recordInfo.setAlarmName(result.getString("falarmname"));
        recordInfo.setLevel(result.getString("flevel"));
        recordInfo.setMetricName(result.getString("fmetricname"));
        recordInfo.setAlarmMsg(result.getString("falarmmsg"));
        recordInfo.setState(RecordState.getValueOf(result.getString("fstate")));
        recordInfo.setStartTime(AlarmRecordDbHelper.parseStrToLDT(result.getString("fstarttime")));
        recordInfo.setLastTime(AlarmRecordDbHelper.parseStrToLDT(result.getString("flasttime")));
        String restoreTime = result.getString("frestoretime");
        if (StringUtils.isNotEmpty((String)restoreTime)) {
            recordInfo.setRestoreTime(AlarmRecordDbHelper.parseStrToLDT(restoreTime));
        }
        recordInfo.setTotalNumber(Integer.parseInt(result.getString("ftotalnumber")));
        recordInfo.setDuration(Integer.parseInt(result.getString("fduration")));
        String extJson = result.getString("fextjson");
        if (StringUtils.isNotEmpty((String)extJson)) {
            recordInfo.setRecordExtInfo((RecordInfo.RecordExtInfo)JSONUtils.cast((String)extJson, RecordInfo.RecordExtInfo.class));
        }
        return recordInfo;
    }

    public static void saveRecord(RecordInfo recordInfo) throws IOException {
        DBRequest dbRequest = new DBRequest();
        long id = recordInfo.getId();
        if (AlarmRecordDbHelper.getRecordInfo(id) == null) {
            ArrayList insertList = new ArrayList(10);
            Collections.addAll(insertList, recordInfo.getId(), recordInfo.getAppName(), recordInfo.getIp(), recordInfo.getAlarmId(), recordInfo.getAlarmName(), recordInfo.getLevel(), recordInfo.getMetricName(), recordInfo.getState().getDesc(), recordInfo.getAlarmMsg(), recordInfo.getStartTime(), recordInfo.getLastTime(), recordInfo.getTotalNumber(), recordInfo.getDuration(), recordInfo.getRestoreTime(), JSONUtils.toString((Object)recordInfo.getRecordExtInfo()));
            String insertSql = AlarmRecordDbHelper.buildInsertSql("T_MONITOR_ALARM_RECORD", DBFields.AlarmRecord.getAllFields().length);
            dbRequest.setInsertRequest(new DBRequest.InsertRequest(insertSql, insertList));
            MetadataFactory.getStatement().executeInsert((Request)dbRequest);
        } else {
            String updateSql = AlarmRecordDbHelper.buildUpdateSql("T_MONITOR_ALARM_RECORD", DBFields.AlarmRecord.getUpdateFields("fid"), new String[]{"fid"});
            ArrayList updateList = new ArrayList(10);
            Collections.addAll(updateList, recordInfo.getAppName(), recordInfo.getIp(), recordInfo.getAlarmId(), recordInfo.getAlarmName(), recordInfo.getLevel(), recordInfo.getMetricName(), recordInfo.getState().getDesc(), recordInfo.getAlarmMsg(), recordInfo.getStartTime(), recordInfo.getLastTime(), recordInfo.getTotalNumber(), recordInfo.getDuration(), recordInfo.getRestoreTime(), JSONUtils.toString((Object)recordInfo.getRecordExtInfo()), recordInfo.getId());
            dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(updateSql, updateList));
            MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
        }
    }

    public static void saveAlarmRecord(String ip, String alarmName, String metricName, String state, String alarmMsg) throws IOException {
        RecordState recordState = RecordState.getValueOf(state);
        if (recordState == null) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"unsupported RecordState:" + state});
        }
        AlarmInfo alarmInfo = AlarmConfigDbHelper.getAlarmInfoByName(alarmName);
        if (alarmInfo == null) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"alarmName not exist in t_monitor_alarm_config,alarmName=:" + alarmName});
        }
        String instanceId = null;
        List allNodeInfo = ServiceInfoFactory.get().getServiceList();
        for (ServiceInfo tempServiceInfo : allNodeInfo) {
            if (!ip.equals(tempServiceInfo.getIp())) continue;
            instanceId = tempServiceInfo.getInstanceId();
            break;
        }
        RecordInfo recordInfo = AlarmRecordDbHelper.getRecordInfo(instanceId, alarmInfo.getId(), metricName);
        LocalDateTime now = LocalDateTime.now();
        if (recordInfo == null) {
            recordInfo = new RecordInfo();
            recordInfo.setId(ID.genLongId());
            recordInfo.setStartTime(now);
            recordInfo.setDuration(0);
            recordInfo.setTotalNumber(1);
            recordInfo.setLastTime(now);
        } else if (recordState == RecordState.OK) {
            recordInfo.setRestoreTime(now);
            recordInfo.setDuration((int)Duration.between(recordInfo.getStartTime(), now).getSeconds());
        } else {
            if (recordInfo.getState() == RecordState.OK || recordInfo.getState() == RecordState.RESTART) {
                recordInfo.setStartTime(now);
                recordInfo.setDuration(0);
                recordInfo.setTotalNumber(1);
                recordInfo.setRestoreTime(null);
            } else {
                recordInfo.setTotalNumber(recordInfo.getTotalNumber() + 1);
                recordInfo.setDuration((int)Duration.between(recordInfo.getStartTime(), now).getSeconds());
            }
            recordInfo.setLastTime(now);
        }
        for (MetricInfo metricInfo : alarmInfo.getMetricInfoList()) {
            if (!metricName.equals(metricInfo.getMetricName())) continue;
            recordInfo.setLevel(metricInfo.getLevel());
            break;
        }
        recordInfo.setAppName(Instance.getAppName());
        recordInfo.setIp(instanceId);
        recordInfo.setAlarmId(alarmInfo.getId());
        recordInfo.setAlarmName(alarmName);
        recordInfo.setMetricName(metricName);
        recordInfo.setState(recordState);
        recordInfo.setAlarmMsg(alarmMsg);
        AlarmRecordDbHelper.saveRecord(recordInfo);
    }

    public static List<RecordInfo> findRecordInfosByState(String state) throws IOException {
        ArrayList queryList = new ArrayList(1);
        Collections.addAll(queryList, state);
        DBRequest dbRequest = new DBRequest();
        String querySql = AlarmRecordDbHelper.buildQuerySql("T_MONITOR_ALARM_RECORD", DBFields.AlarmRecord.getAllFields(), new String[]{"fstate"});
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
        List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        if (!results.isEmpty()) {
            ArrayList<RecordInfo> recordInfos = new ArrayList<RecordInfo>(8);
            for (Result result : results) {
                recordInfos.add(AlarmRecordDbHelper.resultToRecordInfo(result));
            }
            return recordInfos;
        }
        return null;
    }
}

