/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.apicall;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dc.utils.MCApiUtil;
import kd.bos.exception.KDException;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.govern.GovernConfigs;
import kd.bos.govern.StorageType;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.government.metadata.db.Row;
import kd.bos.government.storage.Storage;
import kd.bos.government.storage.StorageFactory;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class APICallHandler
extends AbstractHttpHandler {
    private static final Log log = LogFactory.getLog(APICallHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static final String MC_API_GET_MC_DATA = "/kapi/app/mc/DataSaveGetService";
    private static final String CLUSTER_NAME = Instance.getClusterName() + "apiMetadata";
    private static final StorageType storageType = StorageType.getStorageType((String)System.getProperty("apm.gov.invoke.report.storage.type", "elasticsearch"));
    protected static final Storage storage = StorageFactory.getStorage((StorageType)storageType);
    private static final String TIME = "time";
    private static final String COUNT = "count";
    private static final String SIGNATURE = "signature";

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        String apiName;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ApiResponse response = new ApiResponse();
        HashMap<String, Object> retMap = new HashMap<String, Object>(3);
        if (!GovernConfigs.getApicallEnable()) {
            response.setCode(0);
            retMap.put("enable", "false");
            retMap.put("key", "gov.apicall.enable");
            response.setData(retMap);
            this.writeJson(JSONUtils.toString(response), exchange);
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("DCID", CLUSTER_NAME);
        ArrayList<Map<String, Object>> apiStatsList = new ArrayList<Map<String, Object>>(32);
        Map<String, String> params = this.getParams(exchange, false);
        String start = params.get("start");
        String end = params.get("end");
        String apiNameFilter = params.get("apiName");
        String name = apiName = "";
        String apiType = params.get("apiType");
        boolean notEmpty = StringUtils.isNotEmpty((String)name);
        boolean dbIsConfigured = false;
        try {
            if (DBHelper.dbIsConfigured()) {
                dbIsConfigured = true;
            }
            HashSet<String> apiSet = new HashSet<String>(16);
            Map<String, String> appNameConfigs = this.queryApi(name, apiSet);
            if (!notEmpty && !apiSet.isEmpty()) {
                apiName = String.join((CharSequence)"@@", apiSet);
            }
            Map stats = storage.apiCallStats(dateFormat.parse(start), end != null ? dateFormat.parse(end) : new Date(), apiName, "");
            if (dbIsConfigured) {
                Map<String, Map<String, Object>> dbMap = this.getApiMetadataFromDB(stats, name);
                this.covert(dbMap, stats);
                for (Map.Entry<String, Map<String, Object>> entry : dbMap.entrySet()) {
                    Map<String, Object> apiMap = entry.getValue();
                    String signature = (String)apiMap.get(SIGNATURE);
                    if (apiMap.get(COUNT) == null) continue;
                    apiMap.put("desc", "");
                    apiStatsList.add(apiMap);
                }
            } else {
                List list = (List)MCApiUtil.getMCAPIInfo((String)MC_API_GET_MC_DATA, (boolean)true, null, map);
                int subCount = Integer.getInteger("monitor.apicall.limit.db.count", 10000);
                int size = list.size() > subCount ? subCount : list.size();
                list = list.subList(0, size);
                for (String mapStr : list) {
                    Map cast;
                    if (StringUtils.isEmpty((String)mapStr) || "null".equalsIgnoreCase(mapStr) || !(cast = (Map)JSONUtils.cast((String)mapStr, Map.class)).containsKey(SIGNATURE)) continue;
                    this.setStats(cast, stats);
                    String signature = (String)cast.get(SIGNATURE);
                    cast.put("desc", "");
                    apiStatsList.add(cast);
                }
            }
            this.formatData(apiStatsList, appNameConfigs);
            this.filterApiListByapiType(apiStatsList, apiType);
            this.filterDataToAPI(apiStatsList);
            this.sort(apiStatsList, TIME);
            retMap.put(TIME, this.top5(apiStatsList, TIME));
            this.sort(apiStatsList, COUNT);
            retMap.put(COUNT, this.top5(apiStatsList, COUNT));
            if (StringUtils.isNotEmpty((String)apiNameFilter)) {
                this.filterApiListByapiName(apiStatsList, apiNameFilter);
            }
            retMap.put("apiStatsList", apiStatsList);
            response.setData(retMap);
            response.setCode(0);
        }
        catch (Exception e) {
            response.setCode(-1);
            if (e instanceof KDException) {
                if (!"626".equals(((KDException)e).getErrorCode().getCode())) {
                    log.error("\u67e5\u8be2\u5f02\u5e38,\u8bf7\u5728Monitor-\u7cfb\u7edf\u914d\u7f6e-\u5b58\u50a8\u5e93\u914d\u7f6e\u4e2d\u914d\u7f6e\u597dMonitor\u7684\u5b58\u50a8\u5e93:", (Throwable)e);
                    response.setMsg(LangRes.get((String)"APICallHandler_0", (String)"Query exception, please configure Monitor's repository in Monitor-System Configuration-Repository Configuration", (Object[])new Object[0]));
                }
            }
            log.error("API\u76d1\u63a7\u67e5\u8be2\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            response.setMsg(LangRes.get((String)"APICallHandler_1", (String)("API monitoring query exception, exception information:" + e.getMessage()), (Object[])new Object[0]));
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private void filterApiListByapiName(List<Map<String, Object>> apiStatsList, String apiNameFilter) {
        Iterator<Map<String, Object>> iterator = apiStatsList.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> map = iterator.next();
            String apiName = (String)map.get("apiName");
            if (apiName == null || apiName.toLowerCase().contains(apiNameFilter.toLowerCase())) continue;
            iterator.remove();
        }
    }

    private void filterApiListByapiType(List<Map<String, Object>> apiStatsList, String apiType) {
        for (int i = apiStatsList.size() - 1; i >= 0; --i) {
            if (apiType.equals("Web")) {
                if (!apiStatsList.get(i).get("type").equals("http")) {
                    apiStatsList.remove(i);
                    continue;
                }
                apiStatsList.get(i).put("type", "Web");
                continue;
            }
            if (!apiType.equals("RPC")) continue;
            if (apiStatsList.get(i).get("type").equals("http")) {
                apiStatsList.remove(i);
                continue;
            }
            apiStatsList.get(i).put("type", "RPC");
        }
    }

    private void filterDataToAPI(List<Map<String, Object>> apiStatsList) {
        Iterator<Map<String, Object>> iterator = apiStatsList.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> map = iterator.next();
            String signature = (String)map.get(SIGNATURE);
            if (signature != null && signature.contains("/kapi/")) {
                iterator.remove();
                continue;
            }
            map.put("apiName", signature);
        }
    }

    private void formatData(List<Map<String, Object>> list, Map<String, String> config) {
        if (!config.isEmpty()) {
            for (Map<String, Object> apiMap : list) {
                String apiName = apiMap.get(SIGNATURE).toString();
                String desc = config.get(apiName);
                if (desc == null) continue;
                apiMap.put("desc", desc);
            }
        }
    }

    private Map<String, Map<String, Object>> getApiMetadataFromDB(Map<String, Map<String, Object>> statsMap, String name) {
        int apiCount = Integer.getInteger("monitor.apicall.limit.db.count", 2000);
        boolean isAppSplit = false;
        if (Instance.isAppSplit()) {
            isAppSplit = true;
        }
        DBRequest dbRequest = new DBRequest();
        ArrayList<String> queryList = new ArrayList<String>(1);
        StringBuilder querySqlBuilder = new StringBuilder();
        querySqlBuilder.append("select top ").append(apiCount).append(",0 a.fapiname,a.ftype,a.fappid from t_monitor_api_metadata a  where a.fclustername = ? ").append(isAppSplit ? "and a.fappid !=' '" : "");
        if (StringUtils.isNotEmpty((String)name)) {
            querySqlBuilder.append(" and fapiname like '%").append(name).append("%'");
        }
        queryList.add(Instance.getClusterName());
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySqlBuilder.toString(), queryList));
        List retunList = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(8);
        for (Result row : retunList) {
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            String apiName = row.getString("fapiname");
            String type = row.getString("ftype");
            String appId = row.getString("fappid");
            map.put(SIGNATURE, apiName);
            map.put("type", type);
            map.put("appId", appId);
            Map<String, Object> statMap = statsMap.get(apiName);
            if (statMap != null) {
                map.put(COUNT, statMap.get(COUNT));
                map.put(TIME, statMap.get(TIME));
            }
            resultMap.put(apiName, map);
        }
        return resultMap;
    }

    private void covert(Map<String, Map<String, Object>> dbMap, Map<String, Map<String, Object>> statsMap) {
        HashMap<String, Map<String, Object>> addMap = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> entry : statsMap.entrySet()) {
            String key = entry.getKey();
            if (dbMap.containsKey(key)) continue;
            Map<String, Object> signatureMap = entry.getValue();
            signatureMap.put(SIGNATURE, key);
            addMap.put(key, signatureMap);
        }
        dbMap.putAll(addMap);
    }

    private void setStats(Map<String, Object> sourceMap, Map<String, Map<String, Object>> statsMap) {
        for (Map.Entry<String, Map<String, Object>> next : statsMap.entrySet()) {
            String key = next.getKey();
            Map<String, Object> value = next.getValue();
            if (!sourceMap.get(SIGNATURE).toString().equals(key)) continue;
            sourceMap.putAll(value);
            break;
        }
    }

    private void sort(List<Map<String, Object>> list, String type) {
        list.sort((o1, o2) -> {
            Object type2;
            Object type1 = o1.get(type);
            if (type1 == null) {
                type1 = 0.0;
            }
            if ((type2 = o2.get(type)) == null) {
                type2 = 0.0;
            }
            int a = ((Number)type1).intValue();
            int b = ((Number)type2).intValue();
            return b - a;
        });
    }

    private Map<String, Object> top5(List<Map<String, Object>> list, String type) {
        int i;
        HashMap<String, Object> temp = new HashMap<String, Object>(2);
        int min = Math.min(list.size(), 5);
        Object[] xAxis = new Object[min];
        Object[] yAxis = new Object[min];
        for (i = 0; i < min; ++i) {
            Map<String, Object> map = list.get(i);
            Object o = map.get(type);
            xAxis[i] = o == null ? 0.0 : (double)((Number)o).intValue();
            yAxis[i] = map.get("apiName");
            Object desc = map.get("desc");
            yAxis[i] = desc != null && StringUtils.isNotEmpty((String)desc.toString()) ? desc : map.get("apiName");
        }
        for (i = 0; i < yAxis.length; ++i) {
            if (yAxis[i].toString().length() <= 50) continue;
            String str = yAxis[i].toString().substring(0, 50) + "...";
            yAxis[i] = str;
        }
        temp.put("xAxis", xAxis);
        temp.put("yAxis", yAxis);
        return temp;
    }

    private Map<String, String> queryApi(String apiName, Set<String> apiSet) {
        boolean filterApiName = StringUtils.isNotEmpty((String)apiName);
        StringBuilder sql = new StringBuilder("select fapiname,fdesc from t_monitor_api_metadata where fclustername = ? ");
        if (filterApiName) {
            sql.append("and fapiname like '%").append(apiName).append("%' or fdesc like '%").append(apiName).append("%'");
        } else {
            sql.append(" and fdesc is not null ");
        }
        DBRequest dbRequest = new DBRequest();
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(sql.toString(), Collections.singletonList(Instance.getClusterName())));
        List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        HashMap<String, String> result = new HashMap<String, String>(results.size());
        results.forEach(key -> {
            Object desc;
            Row row = (Row)key;
            Map map = row.getMap();
            String appName = map.get("fapiname").toString();
            if (filterApiName) {
                apiSet.add(appName);
            }
            if ((desc = map.get("fdesc")) != null) {
                result.put(appName, String.valueOf(desc));
            }
        });
        return result;
    }
}

