/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.apicall;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.govern.GovernConfigs;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.government.metadata.db.Row;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class APIDescConfigHandler
extends AbstractHttpHandler {
    private static final Log log = LogFactory.getLog(APIDescConfigHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        ApiResponse<Object> response = new ApiResponse<Object>();
        try {
            if (!GovernConfigs.getApicallEnable()) {
                HashMap<String, String> retMap = new HashMap<String, String>(8);
                response.setCode(0);
                retMap.put("enable", "false");
                retMap.put("key", "gov.apicall.enable");
                response.setData(retMap);
                this.writeJson(JSONUtils.toString(response), exchange);
                return;
            }
            Map<String, String> params = this.getParams(exchange, false);
            String action = params.get("action");
            String apiName = params.get("apiName");
            if ("search".equalsIgnoreCase(action)) {
                response.setData(this.queryApi(apiName));
            } else {
                String desc = params.get("desc");
                if (desc == null || desc.length() < 1000) {
                    response.setData(this.editApi(apiName, desc));
                } else {
                    throw new IllegalArgumentException(LangRes.get((String)"APIDescConfigHandler_1", (String)"api desc too long", (Object[])new Object[0]));
                }
            }
            response.setCode(0);
            OPLOGGER.opLog(exchange, OpType.EDIT, LangRes.get((String)"APICallHandler_2", (String)"API\u76d1\u63a7", (Object[])new Object[0]), LangRes.get((String)"APICallHandler_5", (String)"\u4fee\u6539API\u76d1\u63a7\u6570\u636e\uff0cAPI\u540d\u79f0\u4e3a\uff1a", (Object[])new Object[0]) + apiName);
        }
        catch (IllegalArgumentException argumentException) {
            response.setCode(-1);
            response.setMsg(argumentException.getMessage());
        }
        catch (Exception e) {
            response.setCode(-1);
            response.setMsg("api config error, log keyword: APIDescConfigHandler");
            log.error("[APIDescConfigHandler] api config error", (Throwable)e);
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private List<Map<String, Object>> queryApi(String apiName) {
        DBRequest dbRequest = new DBRequest();
        StringBuilder sql = new StringBuilder("select top 10000 fapiname,fappid,fdesc from t_monitor_api_metadata where ftype = 'http' and fclustername = ?");
        if (StringUtils.isNotEmpty((String)apiName)) {
            sql.append(" and fapiname like '%").append(apiName).append("%'");
        }
        sql.append(" order by fdesc,fupdatetime desc");
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(sql.toString(), Collections.singletonList(Instance.getClusterName())));
        List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(results.size());
        results.forEach(key -> {
            Row row = (Row)key;
            result.add(row.getMap());
        });
        return result;
    }

    private List<Map<String, Object>> editApi(String apiName, String desc) {
        DBRequest request = new DBRequest();
        String sql = "update t_monitor_api_metadata set fdesc = ?,fupdatetime = now() where fapiname = ? and fclustername = ?";
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(desc);
        params.add(apiName);
        params.add(Instance.getClusterName());
        request.setUpdateRequest(new DBRequest.UpdateRequest(sql, params));
        MetadataFactory.getStatement().executeUpdate((Request)request);
        return this.queryApi(null);
    }
}

