/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.appha.handler;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.eye.api.appha.entity.AppHealthCheckResult;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.healthmanage.cluster.ClusterHealth;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;

public class AppHealthCheckHandler
extends AbstractHttpHandler {
    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        HashMap<String, Object> response = new HashMap<String, Object>(4);
        try {
            response.put("code", 0);
            response.put("data", this.checkApp());
            response.put("msg", "success");
        }
        catch (Exception e) {
            response.put("code", -1);
            response.put("data", null);
            response.put("msg", e.getMessage());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private List<AppHealthCheckResult> checkApp() {
        Map appHealths = ClusterHealth.getClusterApplicationHealth();
        ArrayList<AppHealthCheckResult> appHealthCheckResultList = new ArrayList<AppHealthCheckResult>(appHealths.size());
        if (appHealths != null) {
            appHealths.forEach((appName, levelMap) -> {
                AppHealthCheckResult appHealthCheckResult = new AppHealthCheckResult();
                appHealthCheckResult.setAppName((String)appName);
                AtomicInteger normal = (AtomicInteger)levelMap.get(HealthLevel.NORMAL.getLevel());
                int normalInt = normal == null ? 0 : normal.get();
                appHealthCheckResult.setHealthNode(normalInt);
                AtomicInteger busy = (AtomicInteger)levelMap.get(HealthLevel.BUSY.getLevel());
                int busyInt = busy == null ? 0 : busy.get();
                appHealthCheckResult.setBusyNode(busyInt);
                AtomicInteger overload = (AtomicInteger)levelMap.get(HealthLevel.OVERLOAD.getLevel());
                int overloadInt = overload == null ? 0 : overload.get();
                appHealthCheckResult.setOverloadNode(overloadInt);
                AtomicInteger error = (AtomicInteger)levelMap.get(HealthLevel.ERROR.getLevel());
                int errorInt = error == null ? 0 : error.get();
                appHealthCheckResult.setExceptionNode(errorInt);
                appHealthCheckResult.setTotalNode(normalInt + busyInt + overloadInt + errorInt);
                this.analyzeAppStatus(appHealthCheckResult);
                appHealthCheckResultList.add(appHealthCheckResult);
            });
        }
        return appHealthCheckResultList;
    }

    private void analyzeAppStatus(AppHealthCheckResult appHealthCheckResult) {
        if (appHealthCheckResult.getTotalNode() == 1) {
            String warn = LangRes.get((String)"AppHealthCheckHandler_0", (String)"Application {0} has a total of 1 node, and high availability deployment has not been performed.", (Object[])new Object[]{appHealthCheckResult.getAppName()});
            appHealthCheckResult.setWarnMessage(warn);
        } else if (appHealthCheckResult.getHealthNode() <= 1) {
            String warn = LangRes.get((String)"AppHealthCheckHandler_1", (String)"Application {0} has a total of {1} nodes, with {2} nodes experiencing overload or exceptions, and only 1 healthy node. There is a risk.", (Object[])new Object[]{appHealthCheckResult.getAppName(), appHealthCheckResult.getTotalNode(), appHealthCheckResult.getBusyNode() + appHealthCheckResult.getExceptionNode()});
            appHealthCheckResult.setWarnMessage(warn);
        } else {
            appHealthCheckResult.setWarnMessage("");
        }
    }
}

