/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.appha.handler;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.eye.api.appha.entity.TimeRangeAndAppNameParam;
import kd.bos.eye.api.appha.entity.loadforward.LoadForwardData;
import kd.bos.eye.api.appha.entity.loadforward.SeriesData;
import kd.bos.eye.api.appha.helper.Utils;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.healthmanage.cluster.ClusterHealth;
import kd.bos.mservice.monitor.query.HealthQuery;
import kd.bos.util.JSONUtils;

public class LoadForwardHandler
extends AbstractHttpHandler {
    private static final Log logger = LogFactory.getLog(LoadForwardHandler.class);

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        HashMap<String, Object> response = new HashMap<String, Object>(4);
        TimeRangeAndAppNameParam param = ExchangeVueUtils.parseJsonFromPost(exchange, TimeRangeAndAppNameParam.class);
        try {
            HashMap<String, Collection<Object>> data = new HashMap<String, Collection<Object>>();
            data.put("appNames", ClusterHealth.getClusterApplicationNames());
            data.put("loadForwardData", this.getLoadForwardData(param));
            response.put("code", 0);
            response.put("data", data);
            response.put("msg", "success");
        }
        catch (Exception e) {
            response.put("code", -1);
            response.put("data", null);
            response.put("msg", e.getMessage());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private List<LoadForwardData> getLoadForwardData(TimeRangeAndAppNameParam param) throws ParseException {
        ArrayList<LoadForwardData> loadForwardDataList = new ArrayList<LoadForwardData>();
        Date[] dateTimeRange = Utils.getQueryDateTimeRange(param);
        List<String> selectedAppNames = param.getSelectedAppNames();
        if (selectedAppNames.isEmpty()) {
            return loadForwardDataList;
        }
        try {
            TypeReference<Map<String, Map<String, List<String>>>> dataType = new TypeReference<Map<String, Map<String, List<String>>>>(){};
            for (String appName : selectedAppNames) {
                JSONObject jsonObject = HealthQuery.queryHistoryTps((String)appName, (Date)dateTimeRange[0], (Date)dateTimeRange[1]);
                String dataJson = jsonObject.toJSONString();
                Map dataMap = (Map)Utils.OBJECT_MAPPER.readValue(dataJson, (TypeReference)dataType);
                for (Map.Entry dataEntry : dataMap.entrySet()) {
                    LoadForwardData loadForwardData = new LoadForwardData();
                    loadForwardData.setInstanceName((String)dataEntry.getKey());
                    Map valueMap = (Map)dataEntry.getValue();
                    List aAxis = (List)valueMap.remove("xAxis");
                    loadForwardData.setxAxis(aAxis);
                    ArrayList<SeriesData> seriesDataList = new ArrayList<SeriesData>(valueMap.size());
                    for (Map.Entry valueEntry : valueMap.entrySet()) {
                        SeriesData seriesData = new SeriesData();
                        seriesData.setNodeName((String)valueEntry.getKey());
                        seriesData.setData(((List)valueEntry.getValue()).stream().map(s -> s == null ? "0" : s).collect(Collectors.toList()));
                        seriesDataList.add(seriesData);
                    }
                    loadForwardData.setSeriesData(seriesDataList);
                    loadForwardDataList.add(loadForwardData);
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to get load_forward data. ERROR_INFO: ", (Throwable)e);
        }
        return loadForwardDataList;
    }
}

