/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.appha.helper;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dlock.DLock;
import kd.bos.eye.api.appha.helper.HealthIndicatorConfigHook;
import kd.bos.eye.api.appha.helper.Utils;
import kd.bos.eye.api.config.manager.UnifiedConfigManager;
import kd.bos.eye.config.custom.ConfigDbHelper;
import kd.bos.eye.config.custom.ConfigEntity;
import kd.bos.eye.config.custom.ConfigModule;
import kd.bos.id.ID;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.healthmanage.config.ConfigItemMeta;
import kd.bos.mservice.monitor.healthmanage.inspect.IndicatorsInspect;
import kd.bos.util.StringUtils;

public class HealthIndicatorConfigHelper {
    private static final Log logger = LogFactory.getLog(HealthIndicatorConfigHelper.class);
    public static final String indicatorBasePath = "/runtime/monitor/config/indicator";
    private static final TypeReference<Map<String, Object>> dataType = new TypeReference<Map<String, Object>>(){};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initIndicatorConfigs() {
        Map indicatorsMap = IndicatorsInspect.getConfigableIndicatorMeta();
        HealthIndicatorConfigHook.registerHook(indicatorsMap);
        DLock dLock = DLock.create((String)"/dlock/monitor/initConfig/initHealthIndicatorConfig");
        try {
            if (!dLock.tryLock()) {
                return;
            }
            Map<String, String> allIndicatorMap = HealthIndicatorConfigHelper.getIndicatorConfigJsonsFromDB();
            HashMap<String, String> needAddMap = new HashMap<String, String>(8);
            for (Map.Entry indicatorEntry : indicatorsMap.entrySet()) {
                String indicatorName = (String)indicatorEntry.getKey();
                Map indicatorValue = (Map)indicatorEntry.getValue();
                String configJson = "";
                if (allIndicatorMap != null && allIndicatorMap.size() > 0) {
                    configJson = allIndicatorMap.get(indicatorName);
                }
                HashMap configItems = new HashMap();
                if (StringUtils.isEmpty((String)configJson)) {
                    for (Map.Entry configEntry : indicatorValue.entrySet()) {
                        configItems.put(configEntry.getKey(), ((ConfigItemMeta)configEntry.getValue()).getDefaultValue());
                    }
                    needAddMap.put(indicatorName, JSON.toJSONString(configItems));
                    continue;
                }
                HashMap<String, Object> dbConfigItems = new HashMap();
                try {
                    dbConfigItems = (Map)Utils.OBJECT_MAPPER.readValue(configJson, dataType);
                }
                catch (IOException e) {
                    logger.error("JSON from MC to Map failed. ERROR INFO: ", (Throwable)e);
                }
                if (!HealthIndicatorConfigHelper.originIndicatorHasChanged(dbConfigItems, indicatorValue)) continue;
                for (Map.Entry configEntry : indicatorValue.entrySet()) {
                    configItems.put(configEntry.getKey(), ((ConfigItemMeta)configEntry.getValue()).getDefaultValue());
                }
                needAddMap.put(indicatorName, JSON.toJSONString(configItems));
            }
            if (needAddMap.size() > 0) {
                HealthIndicatorConfigHelper.saveIndicatorConfigsToDB(needAddMap);
                logger.info("HealthIndicatorConfigHelper init indicator config to db...");
            }
        }
        catch (Exception e) {
            logger.warn("HealthIndicatorConfigHelper initIndicatorConfigs error: ", (Throwable)e);
        }
        finally {
            dLock.unlock();
        }
    }

    public static void setIndicatorConfigs(Map<String, Map<String, ConfigItemMeta>> indicatorsMap) throws JsonProcessingException {
        Map<String, Map<String, Object>> indicatorConfigs = HealthIndicatorConfigHelper.getIndicatorConfigsFromDB();
        for (Map.Entry<String, Map<String, Object>> indicatorEntry : indicatorConfigs.entrySet()) {
            String indicatorName = indicatorEntry.getKey();
            Map<String, Object> indicatorItems = indicatorEntry.getValue();
            for (Map.Entry<String, Object> itemEntry : indicatorItems.entrySet()) {
                ConfigItemMeta tempConfigMetaMap;
                Map<String, ConfigItemMeta> configItemMetaMap = indicatorsMap.get(indicatorName);
                if (configItemMetaMap == null || (tempConfigMetaMap = configItemMetaMap.get(itemEntry.getKey())) == null) continue;
                tempConfigMetaMap.withDefaultValue(itemEntry.getValue());
            }
        }
    }

    private static boolean originIndicatorHasChanged(Map<String, Object> mcConfigItems, Map<String, ConfigItemMeta> originIndicator) {
        if (mcConfigItems.size() != originIndicator.size()) {
            return true;
        }
        for (String config : mcConfigItems.keySet()) {
            if (originIndicator.containsKey(config)) continue;
            return true;
        }
        return false;
    }

    private static Map<String, Map<String, Object>> getIndicatorConfigsFromDB() {
        Map<String, String> jsonMap = HealthIndicatorConfigHelper.getIndicatorConfigJsonsFromDB();
        HashMap<String, Map<String, Object>> indicatorConfigs = new HashMap<String, Map<String, Object>>(4);
        for (Map.Entry<String, String> entry : jsonMap.entrySet()) {
            Map configItems = new HashMap();
            try {
                configItems = (Map)Utils.OBJECT_MAPPER.readValue(entry.getValue(), dataType);
            }
            catch (Exception e) {
                logger.warn("JSON from db to Map failed. ERROR INFO: ", (Throwable)e);
            }
            indicatorConfigs.put(entry.getKey(), configItems);
        }
        return indicatorConfigs;
    }

    private static Map<String, String> getIndicatorConfigJsonsFromDB() {
        HashMap<String, String> map = new HashMap<String, String>(8);
        List<ConfigEntity> configEntityList = ConfigDbHelper.getConfigsByModule(ConfigModule.HEALTH_INDICATOR_CONFIG.getNumber());
        if (configEntityList != null && configEntityList.size() > 0) {
            for (ConfigEntity configEntity : configEntityList) {
                map.put(configEntity.getKey(), configEntity.getValue());
            }
        }
        return map;
    }

    private static void saveIndicatorConfigsToDB(Map<String, String> configItems) {
        ArrayList<ConfigEntity> configEntityList = new ArrayList<ConfigEntity>(configItems.size());
        for (Map.Entry<String, String> configItem : configItems.entrySet()) {
            ConfigEntity configEntity = new ConfigEntity(String.valueOf(ID.genLongId()), Instance.getClusterName(), configItem.getKey(), configItem.getValue(), ConfigModule.HEALTH_INDICATOR_CONFIG.getNumber(), 1, 1, "", LocalDateTime.now());
            configEntityList.add(configEntity);
        }
        ConfigDbHelper.addConfigsToDb(configEntityList);
    }

    public static void updateIndicatorConfigToDB(String indicatorName, Map<String, Object> configItems) throws JsonProcessingException {
        ConfigEntity configEntity = new ConfigEntity();
        configEntity.setValue(Utils.OBJECT_MAPPER.writeValueAsString(configItems));
        configEntity.setClusterName(Instance.getClusterName());
        configEntity.setModule(ConfigModule.HEALTH_INDICATOR_CONFIG.getNumber());
        configEntity.setKey(indicatorName);
        if (ConfigDbHelper.updateConfigToDbByModuleAndKey(configEntity)) {
            UnifiedConfigManager.getEyeConfigService().saveConfig(indicatorName, Utils.OBJECT_MAPPER.writeValueAsString((Object)configEntity));
        }
    }
}

