/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.armor;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.armor.core.util.StringUtil;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.eye.api.armor.ArmorRuleHandler;
import kd.bos.eye.api.armor.vo.ResourceVo;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.govern.GovernConfigs;
import kd.bos.govern.StorageType;
import kd.bos.government.storage.Storage;
import kd.bos.government.storage.StorageFactory;
import kd.bos.instance.Instance;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.tenant.TenantInfo;
import kd.bos.util.JSONUtils;

public class APILinkHandler
extends AbstractHttpHandler {
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static final StorageType storageType = StorageType.getStorageType((String)System.getProperty("apm.gov.invoke.report.storage.type", "elasticsearch"));
    protected static final Storage storage = StorageFactory.getStorage((StorageType)storageType);

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = null;
        if (!GovernConfigs.getBreakerEnable()) {
            response = new ApiResponse();
            HashMap<String, String> retMap = new HashMap<String, String>(8);
            response.setCode(0);
            retMap.put("enable", "false");
            retMap.put("key", "gov.breaker.enable");
            response.setData(retMap);
            this.writeJson(JSONUtils.toString(response), exchange);
            return;
        }
        try {
            Map<String, String> params = this.getParams(exchange, false);
            String tenantId = params.get("tenantId");
            String appName = params.get("selectAppName");
            String instanceId = params.get("selectInstanceId");
            String resource = params.get("searchKey");
            String startDate = params.get("startDate");
            String endDate = params.get("endDate");
            response = new ApiResponse();
            if (StringUtil.isEmpty((String)appName)) {
                List list = ServiceInfoFactory.get().getServiceList();
                for (ServiceInfo serviceInfo : list) {
                    String tempAppName = serviceInfo.getAppName();
                    if (!tempAppName.contains("web")) continue;
                    appName = tempAppName;
                    break;
                }
            }
            if (StringUtil.isEmpty((String)appName)) {
                appName = Instance.getAppName();
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            HashMap<String, Object> storageMap = new HashMap<String, Object>(5);
            storageMap.put("tenantId", tenantId);
            storageMap.put("appName", appName);
            storageMap.put("instanceId", instanceId);
            storageMap.put("resource", resource);
            storageMap.put("startDate", dateFormat.parse(startDate));
            storageMap.put("endDate", endDate != null ? dateFormat.parse(endDate) : new Date());
            Map resultMap = storage.queryArmorLinkData(storageMap);
            HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
            List<ResourceVo> resultList = ResourceVo.fromMap(resultMap);
            resultList.sort(Comparator.comparing(ResourceVo::getTotalQps).reversed());
            returnMap.put("tenantIds", this.getAllTenantsByCurrentEnv());
            returnMap.put("apiLinkList", resultList);
            returnMap.put("appName", appName);
            returnMap.put("appNameList", ArmorRuleHandler.getAppNames());
            response.setCode(0);
            response.setData(returnMap);
        }
        catch (ParseException e) {
            response.setCode(-1);
            String msg = LangRes.get((String)"APILinkHandler_1", (String)"Link monitoring query exception, exception information: {0}", (Object[])new Object[]{e.getMessage()});
            response.setMsg(msg);
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private List<String> getAllTenantsByCurrentEnv() {
        List tenantInfoList = AccountUtils.getAllTenantsByCurrentEnv();
        ArrayList<String> tenantIds = new ArrayList<String>(1);
        if (!tenantInfoList.isEmpty()) {
            for (TenantInfo tenantInfo : tenantInfoList) {
                tenantIds.add(tenantInfo.getId());
            }
        }
        return tenantIds;
    }
}

