/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.armor;

import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import kd.bos.armor.core.util.AssertUtil;
import kd.bos.armor.core.util.StringUtil;
import kd.bos.eye.api.armor.vo.NodeVo;
import kd.bos.eye.api.log.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class ArmorApiClient {
    private static final String CLUSTER_NODE_PATH = "clusterNode";
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HTTP_HEADER_CONTENT_TYPE_URLENCODED = ContentType.create((String)"application/x-www-form-urlencoded").toString();
    private static Log logger = LogFactory.getLog(ArmorApiClient.class);
    private CloseableHttpAsyncClient httpClient;

    public ArmorApiClient() {
        IOReactorConfig ioConfig = IOReactorConfig.custom().setConnectTimeout(3000).setSoTimeout(10000).setIoThreadCount(Runtime.getRuntime().availableProcessors() * 2).build();
        this.httpClient = HttpAsyncClients.custom().setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){

            protected boolean isRedirectable(String method) {
                return false;
            }
        }).setMaxConnTotal(4000).setMaxConnPerRoute(1000).setDefaultIOReactorConfig(ioConfig).build();
        this.httpClient.start();
    }

    public static ArmorApiClient getInstance() {
        return Holder.apiClient;
    }

    protected static HttpUriRequest postRequest(String url, Map<String, String> params, boolean supportEnhancedContentType) {
        HttpPost httpPost = new HttpPost(url);
        if (params != null && params.size() > 0) {
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, String> entry : params.entrySet()) {
                list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(list, Consts.UTF_8));
            if (!supportEnhancedContentType) {
                httpPost.setHeader(HTTP_HEADER_CONTENT_TYPE, HTTP_HEADER_CONTENT_TYPE_URLENCODED);
            }
        }
        return httpPost;
    }

    public List<NodeVo> fetchClusterNodeOfMachine(String ip, int port, boolean includeZero) {
        String type = "notZero";
        if (includeZero) {
            type = "zero";
        }
        return this.fetchItems(ip, port, CLUSTER_NODE_PATH, type, NodeVo.class);
    }

    @Nullable
    private <T> List<T> fetchItems(String ip, int port, String api, String type, Class<T> ruleType) {
        try {
            AssertUtil.notEmpty((String)ip, (String)"Bad machine IP");
            AssertUtil.isTrue((port > 0 ? 1 : 0) != 0, (String)"Bad machine port");
            HashMap<String, String> params = null;
            if (StringUtil.isNotEmpty((String)type)) {
                params = new HashMap<String, String>(1);
                params.put("type", type);
            }
            return this.fetchItemsAsync(ip, port, api, type, ruleType).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Error when fetching items from api: {} -> {}", new Object[]{api, type, e});
            return null;
        }
        catch (Exception e) {
            logger.error("Error when fetching items: {} -> {}", new Object[]{api, type, e});
            return null;
        }
    }

    @Nullable
    private <T> CompletableFuture<List<T>> fetchItemsAsync(String ip, int port, String api, String type, Class<T> ruleType) {
        AssertUtil.notEmpty((String)ip, (String)"Bad machine IP");
        AssertUtil.isTrue((port > 0 ? 1 : 0) != 0, (String)"Bad machine port");
        HashMap<String, String> params = null;
        if (StringUtil.isNotEmpty((String)type)) {
            params = new HashMap<String, String>(1);
            params.put("type", type);
        }
        return this.executeCommand(ip, port, api, params, false).thenApply(json -> JSON.parseArray((String)json, (Class)ruleType));
    }

    private CompletableFuture<String> executeCommand(String ip, int port, String api, Map<String, String> params, boolean useHttpPost) {
        return this.executeCommand(null, ip, port, api, params, useHttpPost);
    }

    private CompletableFuture<String> executeCommand(String app, String ip, int port, String api, Map<String, String> params, boolean useHttpPost) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        if (StringUtil.isBlank((String)ip) || StringUtil.isBlank((String)api)) {
            future.completeExceptionally(new IllegalArgumentException("Bad URL or command name"));
            return future;
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append("http://");
        urlBuilder.append(ip).append(':').append(port).append('/').append(api);
        if (params == null) {
            params = Collections.emptyMap();
        }
        if (!useHttpPost || !this.isSupportPost(app, ip, port)) {
            if (!params.isEmpty()) {
                if (urlBuilder.indexOf("?") == -1) {
                    urlBuilder.append('?');
                } else {
                    urlBuilder.append('&');
                }
                urlBuilder.append((CharSequence)this.queryString(params));
            }
            return this.executeCommand((HttpUriRequest)new HttpGet(urlBuilder.toString()));
        }
        return this.executeCommand(ArmorApiClient.postRequest(urlBuilder.toString(), params, this.isSupportEnhancedContentType(app, ip, port)));
    }

    private CompletableFuture<String> executeCommand(final HttpUriRequest request) {
        final CompletableFuture<String> future = new CompletableFuture<String>();
        this.httpClient.execute(request, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse response) {
                int statusCode = response.getStatusLine().getStatusCode();
                try {
                    String value = ArmorApiClient.this.getBody(response);
                    if (ArmorApiClient.this.isSuccess(statusCode)) {
                        future.complete(value);
                    } else if (ArmorApiClient.this.isCommandNotFound(statusCode, value)) {
                        future.completeExceptionally(new KDException(request.getURI().getPath()));
                    } else {
                        future.completeExceptionally(new KDException(value));
                    }
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                    logger.error("HTTP request failed: {}", (Object)request.getURI().toString(), (Object)ex);
                }
            }

            public void failed(Exception ex) {
                future.completeExceptionally(ex);
                logger.error("HTTP request failed: {}", (Object)request.getURI().toString(), (Object)ex);
            }

            public void cancelled() {
                future.complete(null);
            }
        });
        return future;
    }

    private String getBody(HttpResponse response) throws Exception {
        Charset charset = null;
        try {
            String contentTypeStr = response.getFirstHeader(HTTP_HEADER_CONTENT_TYPE).getValue();
            if (StringUtil.isNotEmpty((String)contentTypeStr)) {
                ContentType contentType = ContentType.parse((String)contentTypeStr);
                charset = contentType.getCharset();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)(charset != null ? charset : DEFAULT_CHARSET));
    }

    private boolean isSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    private boolean isCommandNotFound(int statusCode, String body) {
        return statusCode == 400 && StringUtil.isNotEmpty((String)body) && body.contains("Unknown command");
    }

    protected boolean isSupportPost(String app, String ip, int port) {
        return StringUtil.isNotEmpty((String)app);
    }

    protected boolean isSupportEnhancedContentType(String app, String ip, int port) {
        return StringUtil.isNotEmpty((String)app);
    }

    private StringBuilder queryString(Map<String, String> params) {
        StringBuilder queryStringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (StringUtil.isEmpty((String)entry.getValue())) continue;
            String name = this.urlEncode(entry.getKey());
            String value = this.urlEncode(entry.getValue());
            if (name == null || value == null) continue;
            if (queryStringBuilder.length() > 0) {
                queryStringBuilder.append('&');
            }
            queryStringBuilder.append(name).append('=').append(value);
        }
        return queryStringBuilder;
    }

    private String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, DEFAULT_CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            logger.info("encode string error: {}", (Object)str, (Object)e);
            return null;
        }
    }

    static class Holder {
        private static ArmorApiClient apiClient = new ArmorApiClient();

        Holder() {
        }
    }
}

