/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.armor;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.eye.api.armor.ArmorRuleHandler;
import kd.bos.eye.api.armor.config.manager.EyeFlowRuleManager;
import kd.bos.eye.api.armor.vo.FlowRuleVo;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.govern.GovernConfigs;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;

public class FlowHandler
extends ArmorRuleHandler<FlowRuleVo> {
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static final Log log = LogFactory.getLog(FlowHandler.class);

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        if (!GovernConfigs.getBreakerEnable()) {
            response = new ApiResponse();
            response.setCode(0);
            map.put("enable", "false");
            map.put("key", "gov.breaker.enable");
            response.setData(map);
            this.writeJson(JSONUtils.toString(response), exchange);
            return;
        }
        try {
            FlowRuleVo flowRuleVo = ExchangeVueUtils.parseJsonFromPost(exchange, FlowRuleVo.class);
            if (flowRuleVo.getId() == null) {
                flowRuleVo.setId(String.valueOf(ID.genLongId()));
            }
            if (flowRuleVo.getRequestType() != 1) {
                this.updateRules(flowRuleVo);
            }
            List flowRuleVos = this.getRule(FlowRuleVo.class);
            map.put("rules", flowRuleVos);
            map.put("apiList", this.getApiList());
            map.put("appNames", FlowHandler.getAppNames());
            map.put("tenantIds", this.getAllTenantsByCurrentEnv());
            response.setCode(0);
            response.setData(map);
            this.addOpLog(exchange, flowRuleVo.getRequestType());
        }
        catch (Exception e) {
            log.error("flowRule exception, message: ", (Throwable)e);
            response.setCode(-1);
            response.setMsg("flowRule exception, message: " + e.getMessage() + " \u65e5\u5fd7TraceId\u4e3a: " + RequestContext.get().getTraceId());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    @Override
    protected void updateRules(FlowRuleVo rule) throws Exception {
        EyeFlowRuleManager.getArmorDataSource().updateRule(rule);
    }

    private void addOpLog(HttpExchange exchange, int requestType) {
        if (requestType == 1) {
            // empty if block
        }
        if (requestType == 0) {
            OPLOGGER.opLog(exchange, OpType.ADD, LangRes.get((String)"FlowHandler_1", (String)"API\u9650\u6d41\u914d\u7f6e", (Object[])new Object[0]), LangRes.get((String)"FlowHandler_4", (String)"\u65b0\u589eAPI\u9650\u6d41\u914d\u7f6e\u6570\u636e", (Object[])new Object[0]));
        }
        if (requestType == 2) {
            OPLOGGER.opLog(exchange, OpType.EDIT, LangRes.get((String)"FlowHandler_1", (String)"API\u9650\u6d41\u914d\u7f6e", (Object[])new Object[0]), LangRes.get((String)"FlowHandler_5", (String)"\u4fee\u6539API\u9650\u6d41\u914d\u7f6e\u6570\u636e", (Object[])new Object[0]));
        }
        if (requestType == 3) {
            OPLOGGER.opLog(exchange, OpType.DELETE, LangRes.get((String)"FlowHandler_1", (String)"API\u9650\u6d41\u914d\u7f6e", (Object[])new Object[0]), LangRes.get((String)"FlowHandler_6", (String)"\u5220\u9664API\u9650\u6d41\u914d\u7f6e\u6570\u636e", (Object[])new Object[0]));
        }
    }
}

