/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.armor.config.dataSource;

import com.alibaba.fastjson.JSON;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.armor.vo.DegradeRuleVo;
import kd.bos.eye.api.armor.vo.FlowRuleVo;
import kd.bos.eye.api.armor.vo.RuleVo;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Statement;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.instance.Instance;

public class ArmorWritableSourceManager {
    public static boolean write(RuleVo ruleVo) {
        String resource = null;
        String jsonValue = JSON.toJSONString((Object)ruleVo);
        String type = null;
        String id = ruleVo.getId();
        int updateType = ruleVo.getRequestType();
        if (ruleVo instanceof FlowRuleVo) {
            resource = ((FlowRuleVo)ruleVo).getResource().replaceAll("/", "-");
            type = "flow";
            return ArmorWritableSourceManager.persistentSaveDB(updateType, id, type, resource, jsonValue);
        }
        resource = ((DegradeRuleVo)ruleVo).getResource().replaceAll("/", "-");
        type = "degrade";
        return ArmorWritableSourceManager.persistentSaveDB(updateType, id, type, resource, jsonValue);
    }

    public static boolean writeBatch(List<RuleVo> ruleVo) {
        if (ruleVo == null || ruleVo.size() == 0) {
            return false;
        }
        return ArmorWritableSourceManager.persistentSaveDBBatch(ruleVo);
    }

    private static boolean persistentSaveDBBatch(List<RuleVo> ruleVo) {
        ArrayList<DBRequest> dbRequestList = new ArrayList<DBRequest>(ruleVo.size());
        int updateCount = 0;
        int insertCount = 0;
        for (RuleVo ruleVoTemp : ruleVo) {
            String type;
            String resource;
            if (ruleVoTemp.getStatIntervalMs() != 1000 && (ruleVoTemp.getStatIntervalMs() % 10 != 0 || ruleVoTemp.getStatIntervalMs() <= 0 || ruleVoTemp.getStatIntervalMs() > 1000000000)) {
                throw new KDException(BosErrorCode.paramError, new Object[]{"The statInterval must be a number equal to 1 or a multiple of 10 less than 1000000 "});
            }
            if (ruleVoTemp.getRequestType() == 3) {
                throw new KDException(BosErrorCode.paramError, new Object[]{"Armor batch delete operation is not supported"});
            }
            if (ruleVoTemp.getRequestType() == 0) {
                ++insertCount;
            } else {
                ++updateCount;
            }
            if (updateCount > 0 && insertCount > 0) {
                throw new KDException(BosErrorCode.paramError, new Object[]{"Armor batch operation, does not support insert and update operations at the same time"});
            }
            if (ruleVoTemp instanceof FlowRuleVo) {
                resource = ((FlowRuleVo)ruleVoTemp).getResource().replaceAll("/", "-");
                type = "flow";
            } else {
                resource = ((DegradeRuleVo)ruleVoTemp).getResource().replaceAll("/", "-");
                type = "degrade";
            }
            DBRequest dbRequest = ArmorWritableSourceManager.getDBRequest(ruleVoTemp.getRequestType(), ruleVoTemp.getId(), type, resource, JSON.toJSONString((Object)ruleVoTemp));
            dbRequestList.add(dbRequest);
        }
        Statement statement = MetadataFactory.getStatement();
        switch (ruleVo.get(0).getRequestType()) {
            case 0: {
                statement.executeInsertBatch(dbRequestList);
                return true;
            }
            case 2: {
                statement.executeUpdateBatch(dbRequestList);
                return true;
            }
        }
        return false;
    }

    private static boolean persistentSaveDB(int updateType, String id, String type, String resource, String value) {
        DBRequest dbRequest = ArmorWritableSourceManager.getDBRequest(updateType, id, type, resource, value);
        Statement statement = MetadataFactory.getStatement();
        switch (updateType) {
            case 0: {
                return statement.executeInsert((Request)dbRequest) > 0;
            }
            case 2: {
                return statement.executeUpdate((Request)dbRequest) > 0;
            }
            case 3: {
                return statement.executeDelete((Request)dbRequest) > 0;
            }
        }
        return false;
    }

    private static DBRequest getDBRequest(int updateType, String id, String type, String resource, String value) {
        DBRequest dbRequest = new DBRequest();
        switch (updateType) {
            case 0: {
                String insertSql = "insert into t_monitor_armor_rule values(?,?,?,?,?,?)";
                ArrayList insertList = new ArrayList(6);
                Collections.addAll(insertList, id, Instance.getClusterName(), type, resource, value, LocalDateTime.now());
                dbRequest.setInsertRequest(new DBRequest.InsertRequest(insertSql, insertList));
                return dbRequest;
            }
            case 2: {
                String updateSql = "update t_monitor_armor_rule set fvalue= ?,fupdatetime = ? where fid = ?";
                ArrayList updateList = new ArrayList(3);
                Collections.addAll(updateList, value, LocalDateTime.now(), id);
                dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(updateSql, updateList));
                return dbRequest;
            }
            case 3: {
                String deleteSql = "delete from t_monitor_armor_rule where fid = ?";
                ArrayList deleteList = new ArrayList(1);
                Collections.addAll(deleteList, id);
                dbRequest.setDeleteRequest(new DBRequest.DeleteRequest(deleteSql, deleteList));
                return dbRequest;
            }
        }
        return dbRequest;
    }

    public static boolean rollBack(String id) {
        DBRequest dbRequest = new DBRequest();
        String deleteSql = "delete from t_monitor_armor_rule where fid = ?";
        ArrayList deleteList = new ArrayList(1);
        Collections.addAll(deleteList, id);
        dbRequest.setDeleteRequest(new DBRequest.DeleteRequest(deleteSql, deleteList));
        return MetadataFactory.getStatement().executeDelete((Request)dbRequest) > 0;
    }
}

