/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.armor.config.dataSource.zk;

import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kd.bos.armor.core.concurrent.NamedThreadFactory;
import kd.bos.armor.core.log.RecordLog;
import kd.bos.armor.transport.datasource.Converter;
import kd.bos.dlock.DLock;
import kd.bos.eye.api.armor.config.dataSource.ArmorDataSource;
import kd.bos.eye.api.armor.config.dataSource.ArmorWritableSourceManager;
import kd.bos.eye.api.armor.vo.RuleVo;
import kd.bos.eye.api.log.KDException;
import kd.bos.eye.util.EyeZkFactory;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;

public class ZookeeperDataSource<T>
extends ArmorDataSource<T> {
    private static final int RETRY_TIMES = 3;
    private static final int SLEEP_TIME = 1000;
    private static final Object lock = new Object();
    private static final Map<String, CuratorFramework> zkClientMap = new HashMap<String, CuratorFramework>();
    private static final ExecutorService pool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), (ThreadFactory)new NamedThreadFactory("armor-zookeeper-ds-update", true), new ThreadPoolExecutor.DiscardOldestPolicy());
    private final String path;
    private final String region;
    private final Function<String, List<RuleVo>> loadDBDataCall;
    private final String serverAddr;
    private PathChildrenCacheListener listener;
    private CuratorFramework zkClient = null;
    private PathChildrenCache pathChildrenCache = null;

    public ZookeeperDataSource(String region, String path, Converter<String, T> parser, Function<String, List<RuleVo>> loadDBDataCall) {
        super(parser);
        this.region = region;
        this.serverAddr = EyeZkFactory.getZKUrl(region);
        this.path = ZKFactory.getZkRootPath((String)this.serverAddr) + path;
        this.loadDBDataCall = loadDBDataCall;
        this.init(this.serverAddr);
    }

    private void init(String serverAddr) {
        this.initZookeeperListener(serverAddr);
        this.loadInitialConfigFromDB();
        this.loadInitialConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInitialConfigFromDB() {
        block10: {
            DLock dLock = null;
            try {
                List<RuleVo> ruleVos;
                if (!DBHelper.dbIsConfigured() || (ruleVos = this.loadDBDataCall.apply("initDataFromDB")) == null || !EyeZkFactory.isModifyZKUrl(this.region, this.serverAddr) && this.zkClient.checkExists().forPath(this.path) != null) break block10;
                try {
                    dLock = DLock.create((String)this.path);
                    if (this.zkClient.checkExists().forPath(this.path) != null) {
                        this.zkClient.delete().deletingChildrenIfNeeded().forPath(this.path);
                    }
                    for (RuleVo ruleVo : ruleVos) {
                        this.initRuleToZK(ruleVo);
                    }
                }
                catch (Exception e) {
                    RecordLog.warn((String)("[ZookeeperDataSource] loadInitialConfigFromDB saveConfig exception,path: " + this.zkClient), (Throwable)e);
                }
                finally {
                    if (dLock != null) {
                        dLock.unlock();
                    }
                }
            }
            catch (Exception e) {
                RecordLog.warn((String)("[ZookeeperDataSource] loadInitialConfigFromDB exception,path: " + this.zkClient), (Throwable)e);
            }
        }
    }

    private void initRuleToZK(RuleVo ruleVo) {
        try {
            String value = JSON.toJSONString((Object)ruleVo);
            String childrenPath = this.path + '/' + ruleVo.getId();
            Stat exists = (Stat)this.zkClient.checkExists().forPath(childrenPath);
            if (exists == null) {
                ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)this.zkClient.create().creatingParentContainersIfNeeded().withMode(CreateMode.PERSISTENT)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath(childrenPath, value.getBytes(StandardCharsets.UTF_8));
            } else {
                this.zkClient.setData().forPath(childrenPath, value.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            RecordLog.error((String)"FlowHandler saveRuleToDataSource error", (Throwable)e);
        }
    }

    private void loadInitialConfig() {
        try {
            Object newValue = this.loadConfig();
            if (newValue == null) {
                RecordLog.warn((String)"[ZookeeperDataSource] WARN: initial config is null, you may have to check your data source", (Object[])new Object[0]);
            }
            this.getProperty().updateValue(newValue);
        }
        catch (Exception ex) {
            RecordLog.warn((String)"[ZookeeperDataSource] Error when loading initial config", (Throwable)ex);
        }
    }

    private void initZookeeperListener(String serverAddr) {
        try {
            this.listener = new PathChildrenCacheListener(){

                public void childEvent(CuratorFramework curatorFramework, PathChildrenCacheEvent pathChildrenCacheEvent) throws Exception {
                    Object newValue = ZookeeperDataSource.this.loadConfig();
                    ZookeeperDataSource.this.getProperty().updateValue(newValue);
                }
            };
            this.zkClient = ZKFactory.getZKClient((String)serverAddr);
            this.pathChildrenCache = new PathChildrenCache(this.zkClient, this.path, true);
            this.pathChildrenCache.getListenable().addListener((Object)this.listener, (Executor)pool);
            this.pathChildrenCache.start();
        }
        catch (Exception e) {
            RecordLog.warn((String)"[ZookeeperDataSource] Error occurred when initializing Zookeeper data source", (Throwable)e);
        }
    }

    public String getPath() {
        return this.path;
    }

    public String readSource() throws Exception {
        if (this.zkClient == null) {
            throw new IllegalStateException("Zookeeper has not been initialized or error occurred");
        }
        List childDataList = this.pathChildrenCache.getCurrentData();
        if (null != childDataList && childDataList.size() > 0) {
            ArrayList<String> list = new ArrayList<String>(childDataList.size());
            for (ChildData childData : childDataList) {
                list.add(new String(childData.getData()));
            }
            return ((Object)list).toString();
        }
        return null;
    }

    public void close() throws Exception {
        if (this.pathChildrenCache != null) {
            this.pathChildrenCache.getListenable().removeListener((Object)this.listener);
            this.pathChildrenCache.close();
        }
        if (this.zkClient != null) {
            this.zkClient.close();
        }
        pool.shutdown();
    }

    protected CuratorFramework getZkClient() {
        return this.zkClient;
    }

    @Override
    public void updateRule(RuleVo ruleVo) {
        if (ArmorWritableSourceManager.write(ruleVo)) {
            String id = ruleVo.getId();
            int updateType = ruleVo.getRequestType();
            String jsonValue = JSON.toJSONString((Object)ruleVo);
            this.saveZK(updateType, id, jsonValue);
        }
    }

    @Override
    public void updateRuleLs(List<RuleVo> ruleVo) throws Exception {
    }

    private void saveZK(int updateType, String id, String value) {
        String childrenPath = this.path + '/' + id;
        try {
            switch (updateType) {
                case 0: {
                    ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)this.zkClient.create().creatingParentContainersIfNeeded().withMode(CreateMode.PERSISTENT)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath(childrenPath, value.getBytes(StandardCharsets.UTF_8));
                    break;
                }
                case 2: {
                    this.zkClient.setData().forPath(childrenPath, value.getBytes(StandardCharsets.UTF_8));
                    break;
                }
                case 3: {
                    this.zkClient.delete().forPath(childrenPath);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        catch (Exception e) {
            ArmorWritableSourceManager.rollBack(id);
            RecordLog.error((String)"[ZookeeperDataSource] Error when saveZK", (Throwable)e);
            throw new KDException("bos-exception", e);
        }
    }
}

