/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.armor.config.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.instance.Instance;

public class ArmorRuleManager {
    public static List<String> getRule(String ruleType) {
        if (DBHelper.dbIsConfigured()) {
            return ArmorRuleManager.getFromDB(ruleType);
        }
        return null;
    }

    private static List<String> getFromDB(String ruleType) {
        ArrayList<String> resultList;
        DBRequest dbRequest = new DBRequest();
        String querySql = "select fvalue,fupdatetime from t_monitor_armor_rule where fclustername = ? and ftype = ?";
        ArrayList queryList = new ArrayList(2);
        Collections.addAll(queryList, Instance.getClusterName(), ruleType);
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
        try {
            List retunList = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            resultList = new ArrayList<String>(retunList.size());
            for (Result row : retunList) {
                String jsonValue = row.getString("fvalue");
                resultList.add(jsonValue);
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.paramError, new Object[]{e});
        }
        return resultList;
    }
}

