/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.armor.dataSource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kd.bos.armor.core.concurrent.NamedThreadFactory;
import kd.bos.armor.core.log.RecordLog;
import kd.bos.armor.core.util.StringUtil;
import kd.bos.armor.transport.datasource.AbstractDataSource;
import kd.bos.armor.transport.datasource.Converter;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.AuthInfo;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;

@Deprecated
public class ZookeeperDataSource<T>
extends AbstractDataSource<String, T> {
    private final ExecutorService pool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), (ThreadFactory)new NamedThreadFactory("Armor-zookeeper-ds-update"), new ThreadPoolExecutor.DiscardOldestPolicy());
    private final String path;
    private PathChildrenCacheListener listener;
    private CuratorFramework zkClient = null;
    private PathChildrenCache pathChildrenCache = null;

    public ZookeeperDataSource(String serverAddr, String path, Converter<String, T> parser) {
        super(parser);
        if (StringUtil.isBlank((String)serverAddr) || StringUtil.isBlank((String)path)) {
            throw new IllegalArgumentException(String.format("Bad argument: serverAddr=[%s], path=[%s]", serverAddr, path));
        }
        this.path = path;
        this.init(serverAddr, null);
    }

    public ZookeeperDataSource(String serverAddr, String groupId, String dataId, Converter<String, T> parser) {
        super(parser);
        if (StringUtil.isBlank((String)serverAddr) || StringUtil.isBlank((String)groupId) || StringUtil.isBlank((String)dataId)) {
            throw new IllegalArgumentException(String.format("Bad argument: serverAddr=[%s], groupId=[%s], dataId=[%s]", serverAddr, groupId, dataId));
        }
        this.path = this.formPath(groupId, dataId);
        this.init(serverAddr, null);
    }

    public ZookeeperDataSource(String serverAddr, List<AuthInfo> authInfos, String groupId, String dataId, Converter<String, T> parser) {
        super(parser);
        if (StringUtil.isBlank((String)serverAddr) || StringUtil.isBlank((String)groupId) || StringUtil.isBlank((String)dataId)) {
            throw new IllegalArgumentException(String.format("Bad argument: serverAddr=[%s], authInfos=[%s], groupId=[%s], dataId=[%s]", serverAddr, authInfos, groupId, dataId));
        }
        this.path = this.formPath(groupId, dataId);
        this.init(serverAddr, authInfos);
    }

    private void init(String serverAddr, List<AuthInfo> authInfos) {
        this.initZookeeperListener(serverAddr, authInfos);
        this.loadInitialConfig();
    }

    private void loadInitialConfig() {
        try {
            Object newValue = this.loadConfig();
            this.getProperty().updateValue(newValue);
        }
        catch (Exception ex) {
            RecordLog.warn((String)"[ZookeeperDataSource] Error when loading initial config", (Throwable)ex);
        }
    }

    private void initZookeeperListener(String serverAddr, List<AuthInfo> authInfos) {
        try {
            this.listener = new PathChildrenCacheListener(){

                public void childEvent(CuratorFramework curatorFramework, PathChildrenCacheEvent pathChildrenCacheEvent) throws Exception {
                    Object newValue = ZookeeperDataSource.this.loadConfig();
                    ZookeeperDataSource.this.getProperty().updateValue(newValue);
                }
            };
            String zkKey = this.getZkKey(serverAddr, authInfos);
            this.zkClient = ZKFactory.getZKClient((String)zkKey);
            this.pathChildrenCache = new PathChildrenCache(this.zkClient, this.path, true);
            this.pathChildrenCache.getListenable().addListener((Object)this.listener, (Executor)this.pool);
            this.pathChildrenCache.start();
        }
        catch (Exception e) {
            RecordLog.warn((String)"[ZookeeperDataSource] Error occurred when initializing Zookeeper data source", (Throwable)e);
        }
    }

    public String readSource() {
        if (this.zkClient == null) {
            throw new IllegalStateException("Zookeeper has not been initialized or error occurred");
        }
        List childDataList = this.pathChildrenCache.getCurrentData();
        if (null != childDataList && childDataList.size() > 0) {
            ArrayList<String> list = new ArrayList<String>(childDataList.size());
            for (ChildData childData : childDataList) {
                list.add(new String(childData.getData()));
            }
            return ((Object)list).toString();
        }
        return null;
    }

    public void close() throws Exception {
        if (this.pathChildrenCache != null) {
            this.pathChildrenCache.getListenable().removeListener((Object)this.listener);
            this.pathChildrenCache.close();
        }
        if (this.zkClient != null) {
            this.zkClient.close();
        }
        this.pool.shutdown();
    }

    private String formPath(String groupId, String dataId) {
        return groupId + dataId;
    }

    public String getPath() {
        return this.path;
    }

    private String getZkKey(String serverAddr, List<AuthInfo> authInfos) {
        if (authInfos == null || authInfos.size() == 0) {
            return serverAddr;
        }
        StringBuilder builder = new StringBuilder(64);
        builder.append(serverAddr).append(this.getAuthInfosKey(authInfos));
        return builder.toString();
    }

    private String getAuthInfosKey(List<AuthInfo> authInfos) {
        StringBuilder builder = new StringBuilder(32);
        for (AuthInfo authInfo : authInfos) {
            if (authInfo == null) {
                builder.append("{}");
                continue;
            }
            builder.append("{sc=").append(authInfo.getScheme()).append(",au=").append(Arrays.toString(authInfo.getAuth())).append("}");
        }
        return builder.toString();
    }

    public CuratorFramework getZkClient() {
        return this.zkClient;
    }
}

