/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.armor.repository;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.eye.api.armor.repository.DegradeRuleRepository;
import kd.bos.eye.api.armor.repository.FlowRuleRepository;
import kd.bos.eye.api.armor.repository.RuleRepository;

public class RepositoryFactory {
    private static final RepositoryFactory INSTANCE = new RepositoryFactory();
    private static Map<String, RuleRepository> repositoryPool = new ConcurrentHashMap<String, RuleRepository>(4);

    private RepositoryFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleRepository getOrCreateRepository(String type) {
        RuleRepository ruleRepository = repositoryPool.get(type);
        if (ruleRepository == null) {
            Map<String, RuleRepository> map = repositoryPool;
            synchronized (map) {
                ruleRepository = repositoryPool.get(type);
                if (ruleRepository == null) {
                    if (type.equals("flow")) {
                        ruleRepository = new FlowRuleRepository();
                    } else if (type.equals("degrade")) {
                        ruleRepository = new DegradeRuleRepository();
                    } else {
                        throw new RuntimeException("Type not supported");
                    }
                    repositoryPool.put(type, ruleRepository);
                }
            }
        }
        return ruleRepository;
    }

    public static RepositoryFactory getInstance() {
        return INSTANCE;
    }
}

