/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.config;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.eye.api.config.manager.RpcConfigManager;
import kd.bos.eye.api.config.vo.RpcConfigInfo;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.id.ID;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.config.MserviceAssemblyConfig;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class RpcConfigHandler
extends AbstractHttpHandler {
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static final Log log = LogFactory.getLog(RpcConfigHandler.class);

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        try {
            HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
            if (!DBHelper.dbIsConfigured()) {
                response.setCode(0);
                returnMap.put("enable", "false");
                response.setData(returnMap);
                this.writeJson(JSONUtils.toString(response), exchange);
                return;
            }
            RpcConfigInfo paramInfo = ExchangeVueUtils.parseJsonFromPost(exchange, RpcConfigInfo.class);
            int page = paramInfo.getPage();
            int size = paramInfo.getSize();
            int requestType = paramInfo.getRequestType();
            String queryApiName = null;
            if (requestType == 2) {
                this.updateRpcConfigInfo(paramInfo);
            } else {
                queryApiName = paramInfo.getApiName();
            }
            boolean isAppSplit = Instance.isAppSplit();
            int totalRows = this.getTotalRows(queryApiName, isAppSplit);
            DBRequest dbRequest = new DBRequest();
            ArrayList queryList = new ArrayList(3);
            int offset = (page - 1) * size;
            StringBuilder querySqlBuilder = new StringBuilder();
            String querySql = null;
            if (StringUtils.isEmpty((String)queryApiName)) {
                querySql = querySqlBuilder.append("select top ").append(size).append(',').append(offset).append(" fapiname, fappid, ftimeout,fupdatetime from (").append("select a.fapiname,a.fappid,r.ftimeout,ISNULL(r.fupdatetime,?) as fupdatetime from t_monitor_api_metadata a left join t_monitor_rpc_config r on a.fapiname = r.fapiname and a.fappid = r.fappid ").append("where a.fclustername = ? and a.ftype = ? ").append(isAppSplit ? "and a.fappid !=' '" : "and (a.fappid =' ' or a.fappid = 'qing')").append(") ar").append(" ORDER BY ar.fupdatetime desc").toString();
                Collections.addAll(queryList, LocalDate.of(2000, 1, 1), Instance.getClusterName(), MserviceAssemblyConfig.MSERVICE_RPC_TYPE);
            } else {
                querySql = querySqlBuilder.append("select top ").append(size).append(',').append(offset).append(" fapiname, fappid, ftimeout,fupdatetime from (").append("select a.fapiname,a.fappid,r.ftimeout,ISNULL(r.fupdatetime,?) as fupdatetime from t_monitor_api_metadata a left join t_monitor_rpc_config r on a.fapiname = r.fapiname and a.fappid = r.fappid ").append("where a.fclustername = ? and a.ftype = ? ").append(isAppSplit ? "and a.fappid !=' '" : "and (a.fappid =' ' or a.fappid = 'qing')").append(" and a.fapiname like ? ").append(") ar").append(" ORDER BY ar.fupdatetime desc").toString();
                Collections.addAll(queryList, LocalDate.of(2000, 1, 1), Instance.getClusterName(), MserviceAssemblyConfig.MSERVICE_RPC_TYPE, '%' + queryApiName + '%');
            }
            dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
            List retunList = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            ArrayList<RpcConfigInfo> resultList = new ArrayList<RpcConfigInfo>(retunList.size());
            String defaultTimeout = null;
            if ("dubbo".equals(MserviceAssemblyConfig.MSERVICE_RPC_TYPE)) {
                defaultTimeout = System.getProperty("dubbo.consumer.timeout");
            } else if ("feign".equals(MserviceAssemblyConfig.MSERVICE_RPC_TYPE)) {
                defaultTimeout = System.getProperty("mservice.consumer.readTimeout", "580000");
            }
            for (Result row : retunList) {
                RpcConfigInfo rpcConfigInfo = new RpcConfigInfo();
                String apiName = row.getString("fapiname");
                String timeout = row.getString("ftimeout");
                Date date = row.getDate("fupdatetime");
                rpcConfigInfo.setApiName(apiName);
                rpcConfigInfo.setAppId(row.getString("fappid"));
                rpcConfigInfo.setTimeout(StringUtils.isNotEmpty((String)timeout) ? timeout : defaultTimeout);
                rpcConfigInfo.setUpdateTime(date);
                resultList.add(rpcConfigInfo);
            }
            this.dateSort(resultList);
            returnMap.put("rpcConfigList", resultList);
            returnMap.put("total", totalRows);
            response.setCode(0);
            response.setData(returnMap);
            this.addOpLog(exchange, requestType);
        }
        catch (Exception e) {
            log.error("RPC\u8d85\u65f6\u914d\u7f6e\u67e5\u8be2\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f:", (Throwable)e);
            response.setCode(-1);
            response.setMsg(LangRes.get((String)"RpcConfigHandler_1", (String)("Query exception, exception information: " + e.getMessage()), (Object[])new Object[0]));
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private void dateSort(List<RpcConfigInfo> list) {
        list.sort((o1, o2) -> {
            Long time1 = o1.getUpdateTime() == null ? Long.valueOf(0L) : Long.valueOf(o1.getUpdateTime().getTime());
            Long time2 = o2.getUpdateTime() == null ? Long.valueOf(0L) : Long.valueOf(o2.getUpdateTime().getTime());
            if (time2 > time1) {
                return 1;
            }
            return 0;
        });
    }

    private int getTotalRows(String queryApiName, boolean isAppSplit) {
        StringBuilder querySqlBuilder = new StringBuilder();
        String querySql = null;
        DBRequest dbRequest = new DBRequest();
        ArrayList queryList = new ArrayList(3);
        if (StringUtils.isEmpty((String)queryApiName)) {
            querySql = querySqlBuilder.append("select count(1) total ").append("from t_monitor_api_metadata a where a.fclustername = ? and a.ftype = ?").append(isAppSplit ? "and a.fappid !=' '" : "and (a.fappid =' ' or a.fappid = 'qing')").toString();
            Collections.addAll(queryList, Instance.getClusterName(), MserviceAssemblyConfig.MSERVICE_RPC_TYPE);
        } else {
            querySql = querySqlBuilder.append("select count(1) total ").append("from t_monitor_api_metadata a where a.fclustername = ? and a.ftype = ? and a.fapiname like ?").append(isAppSplit ? "and a.fappid !=' '" : "and (a.fappid =' ' or a.fappid = 'qing')").toString();
            Collections.addAll(queryList, Instance.getClusterName(), MserviceAssemblyConfig.MSERVICE_RPC_TYPE, '%' + queryApiName + '%');
        }
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
        List retunList = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        return Integer.parseInt(((Result)retunList.get(0)).getString("total"));
    }

    private void updateRpcConfigInfo(RpcConfigInfo rpcConfigInfo) throws Exception {
        DBRequest dbRequest = new DBRequest();
        String apiName = rpcConfigInfo.getApiName();
        String appId = rpcConfigInfo.getAppId() == null ? "" : rpcConfigInfo.getAppId();
        String querySql = "select fid from t_monitor_rpc_config where fclustername = ? and fappid = ? and fapiname = ?";
        ArrayList queryList = new ArrayList(3);
        Collections.addAll(queryList, Instance.getClusterName(), appId, apiName);
        String insertSql = "insert into t_monitor_rpc_config values(?,?,?,?,?,?)";
        ArrayList insertList = new ArrayList(6);
        Collections.addAll(insertList, ID.genLongId(), Instance.getClusterName(), appId, apiName, rpcConfigInfo.getTimeout(), LocalDateTime.now());
        String updateSql = "update t_monitor_rpc_config set ftimeout= ?,fupdatetime = ? where fclustername = ? and fappid = ? and fapiname = ?";
        ArrayList updateList = new ArrayList(5);
        Collections.addAll(updateList, rpcConfigInfo.getTimeout(), LocalDateTime.now(), Instance.getClusterName(), rpcConfigInfo.getAppId(), rpcConfigInfo.getApiName());
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList)).setInsertRequest(new DBRequest.InsertRequest(insertSql, insertList)).setUpdateRequest(new DBRequest.UpdateRequest(updateSql, updateList));
        boolean flag = MetadataFactory.getStatement().execute((Request)dbRequest);
        if (!flag) {
            return;
        }
        String childrenPath = null;
        StringBuilder sb = new StringBuilder();
        childrenPath = StringUtils.isNotEmpty((String)appId) ? sb.append(appId).append(".").append(rpcConfigInfo.getApiName()).toString() : sb.append(rpcConfigInfo.getApiName()).toString();
        RpcConfigManager.getEyeConfigService().saveConfig(childrenPath, rpcConfigInfo.getTimeout());
    }

    private void addOpLog(HttpExchange exchange, int requestType) {
        if (requestType == 1) {
            // empty if block
        }
        if (requestType == 2) {
            OPLOGGER.opLog(exchange, OpType.EDIT, LangRes.get((String)"RpcConfigHandler_2", (String)"\u8d85\u65f6\u8bbe\u7f6e", (Object[])new Object[0]), LangRes.get((String)"RpcConfigHandler_5", (String)"\u4fee\u6539\u8d85\u65f6\u65f6\u95f4", (Object[])new Object[0]));
        }
    }
}

