/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.config.manager;

import java.io.IOException;
import java.sql.Connection;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.appha.helper.HealthIndicatorConfigHelper;
import kd.bos.eye.api.dashboard.init.DashboardHelper;
import kd.bos.eye.api.permission.dao.RoleDao;
import kd.bos.eye.api.permission.dao.UserDao;
import kd.bos.eye.config.custom.ConfigDbHelper;
import kd.bos.framework.zoowhisper.ZooEventifyCenter;
import kd.bos.framework.zoowhisper.ZooEventifyCenterFactory;
import kd.bos.govern.GovernPoJo;
import kd.bos.government.metadata.db.DBConfig;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.government.metadata.db.TableInit;
import kd.bos.government.reporter.MCReporter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class DbConfigManager {
    private static final Log log = LogFactory.getLog(DbConfigManager.class);

    public static void initDbConfig() {
        try {
            DbConfigManager.initListener();
            DBConfig dbConfig = DBHelper.getDbConfig();
            if (dbConfig != null && !"false".equals(System.getProperty("isDBConfigured")) && TableInit.initMonitorTable((DBConfig)dbConfig)) {
                System.setProperty("isDBConfigured", "true");
            }
        }
        catch (Exception e) {
            log.warn("DbConfigManager init dbInfo error", (Throwable)e);
        }
    }

    private static void initListener() {
        try {
            ZooEventifyCenter messageCenter = ZooEventifyCenterFactory.getMessageCenter();
            messageCenter.addWatch("gov.zk.url", DBHelper.getRootPath(), (key, value) -> {
                if ("dbConfig".equals(key) && !StringUtils.isEmpty((String)value) && !"#nullstring#".equals(value)) {
                    try {
                        DBConfig dbConfigInfo = (DBConfig)JSONUtils.cast((String)value, DBConfig.class, (boolean)true);
                        dbConfigInfo.setPassword(Encrypters.decode((String)dbConfigInfo.getPassword()));
                        try (Connection connection = DBHelper.getDBConnection((DBConfig)dbConfigInfo);){
                            DBHelper.clearCache();
                            System.setProperty("isDBConfigured", "true");
                            if (dbConfigInfo.getIsModify()) {
                                TableInit.initMonitorTable((DBConfig)dbConfigInfo);
                                String model = System.getProperty("monitor.dev.model");
                                if (!"debug".equals(model)) {
                                    RoleDao roleDao = new RoleDao();
                                    UserDao userDao = new UserDao();
                                    roleDao.initAdminRole();
                                    userDao.initAdminUser();
                                    log.info("DbConfigManager \u521d\u59cb\u5316\u7528\u6237\u8868\u6210\u529f....");
                                }
                                HealthIndicatorConfigHelper.initIndicatorConfigs();
                                ConfigDbHelper.initConfigToDb();
                            }
                            DashboardHelper.init();
                            log.info("DbConfigManager Monitor\u5b58\u50a8\u5e93\u66f4\u65b0\u6210\u529f....");
                        }
                    }
                    catch (Exception e) {
                        log.error("DbConfigManagerListener error, receive value:" + value, (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            log.warn("[DbConfigManager] Error occurred when initZookeeperListener", (Throwable)e);
        }
    }

    public static void saveConfig(DBConfig dbConfig) throws IOException {
        ZooEventifyCenter messageCenter = ZooEventifyCenterFactory.getMessageCenter();
        messageCenter.setNodeWithPersistent("gov.zk.url", DBHelper.getRootPath(), "dbConfig", JSONUtils.toString((Object)dbConfig));
        new MCReporter().reporter((GovernPoJo)dbConfig);
        DBHelper.clearCache();
        System.setProperty("isDBConfigured", "true");
        ThreadPools.executeOnce((String)"MonitorDbConfigInitThread", () -> {
            String model = System.getProperty("monitor.dev.model");
            if (!"debug".equals(model)) {
                RoleDao roleDao = new RoleDao();
                UserDao userDao = new UserDao();
                roleDao.initAdminRole();
                userDao.initAdminUser();
            }
            HealthIndicatorConfigHelper.initIndicatorConfigs();
            ConfigDbHelper.initConfigToDb();
        });
    }

    public static void updateLocalpropAndDelZK() {
        ZooEventifyCenter messageCenter = ZooEventifyCenterFactory.getMessageCenter();
        messageCenter.deleteNode("gov.zk.url", DBHelper.getRootPath(), "dbConfig");
    }
}

