/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.config.manager;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.config.service.EyeConfigChangeListener;
import kd.bos.eye.config.service.EyeConfigService;
import kd.bos.eye.config.service.EyeConfigServiceFactory;
import kd.bos.government.Constant;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GovernConfigManager {
    private static final Log log = LogFactory.getLog(GovernConfigManager.class);
    private static final GovernConfigChangeListener LISTENER = new GovernConfigChangeListener();
    private static EyeConfigService eyeConfigService;

    public static void registerEyeConfigService() {
        eyeConfigService = EyeConfigServiceFactory.getEyeConfigService("/runtime/monitor/config/govConfig", scene -> {
            if ("initDataFromDB".equals(scene)) {
                Map<String, String> map = GovernConfigManager.getAllGovConfigMap();
                GovernConfigManager.setSystemProperty(map);
                return map;
            }
            if ("schedulePullDataFromDB".equals(scene)) {
                return GovernConfigManager.queryLatestModifyGovConfigMap();
            }
            return null;
        }, LISTENER);
    }

    public static EyeConfigService getEyeConfigService() {
        return eyeConfigService;
    }

    private static Map<String, String> queryLatestModifyGovConfigMap() {
        HashMap<String, String> map = new HashMap<String, String>(8);
        DBRequest dbRequest = new DBRequest();
        String querySql = "select fgovkey,fgovvalue from t_monitor_govern_config  where fclustername = ? and fupdatetime > ?";
        ArrayList queryList = new ArrayList(1);
        Collections.addAll(queryList, Instance.getClusterName(), LocalDateTime.now().minus(Constant.MONITOR_CONFIG_SCHEDULE_QUERY_WITHIN_MINUTES, ChronoUnit.MINUTES));
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
        List rows = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        for (Result row : rows) {
            String govkey = row.getString("fgovkey");
            String govValue = row.getString("fgovvalue");
            if (!GovernConfigManager.isBelongToGovConfigKey(govkey)) continue;
            map.put(govkey, govValue);
        }
        return map;
    }

    public static Map<String, String> getAllGovConfigMap() {
        HashMap<String, String> map = new HashMap<String, String>(8);
        DBRequest dbRequest = new DBRequest();
        String querySql = "select fgovkey,fgovvalue from t_monitor_govern_config  where fclustername = ?";
        ArrayList queryList = new ArrayList(1);
        Collections.addAll(queryList, Instance.getClusterName());
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
        List rows = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        for (Result row : rows) {
            String govkey = row.getString("fgovkey");
            String govValue = row.getString("fgovvalue");
            if (!GovernConfigManager.isBelongToGovConfigKey(govkey)) continue;
            map.put(govkey, govValue);
        }
        return map;
    }

    private static void setSystemProperty(Map<String, String> map) {
        if (map == null || map.size() == 0) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!GovernConfigManager.isBelongToGovConfigKey(entry.getKey())) continue;
            System.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private static boolean isBelongToGovConfigKey(String key) {
        return "gov.topology.enable".equals(key) || "gov.trace.enable".equals(key) || "gov.breaker.enable".equals(key) || "gov.apicall.enable".equals(key);
    }

    private static final class GovernConfigChangeListener
    implements EyeConfigChangeListener {
        private GovernConfigChangeListener() {
        }

        @Override
        public void configUpdate(String key, String value) {
            if (GovernConfigManager.isBelongToGovConfigKey(key)) {
                System.setProperty(key, value);
                log.info("\u6536\u5230\u529f\u80fd\u5f00\u5173\u6539\u53d8\u4e8b\u4ef6\uff1a key: {} ,value: {}", (Object)key, (Object)value);
            }
        }
    }
}

