/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.config.manager;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.config.service.EyeConfigChangeListener;
import kd.bos.eye.config.service.EyeConfigService;
import kd.bos.eye.config.service.EyeConfigServiceFactory;
import kd.bos.government.Constant;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.instance.Instance;
import kd.bos.util.StringUtils;

public class RpcConfigManager {
    private static final RpcConfigChangeListener LISTENER = new RpcConfigChangeListener();
    private static EyeConfigService eyeConfigService;

    public static void registerEyeConfigService() {
        eyeConfigService = EyeConfigServiceFactory.getEyeConfigService("/runtime/monitor/config/rpcConfig", scene -> {
            if ("initDataFromDB".equals(scene)) {
                Map<String, String> allMap = RpcConfigManager.getAllRpcConfigMap();
                RpcConfigManager.setSystemProperty(allMap);
                return allMap;
            }
            if ("schedulePullDataFromDB".equals(scene)) {
                return RpcConfigManager.queryLatestModifyRpcConfigMap();
            }
            return null;
        }, LISTENER);
    }

    public static EyeConfigService getEyeConfigService() {
        return eyeConfigService;
    }

    private static Map<String, String> queryLatestModifyRpcConfigMap() {
        HashMap<String, String> map = new HashMap<String, String>(1);
        DBRequest dbRequest = new DBRequest();
        String querySql = "select fappid,fapiname,ftimeout from t_monitor_rpc_config where fclustername = ?  and fupdatetime > ?";
        ArrayList queryList = new ArrayList(1);
        Collections.addAll(queryList, Instance.getClusterName(), LocalDateTime.now().minus(Constant.MONITOR_CONFIG_SCHEDULE_QUERY_WITHIN_MINUTES, ChronoUnit.MINUTES));
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
        List rows = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        for (Result row : rows) {
            String appId = row.getString("fappid");
            String apiName = row.getString("fapiname");
            String timeout = row.getString("ftimeout");
            if (StringUtils.isNotEmpty((String)appId)) {
                String key = appId + "." + apiName;
                map.put(key, timeout);
                continue;
            }
            map.put(apiName, timeout);
        }
        return map;
    }

    private static Map<String, String> getAllRpcConfigMap() {
        HashMap<String, String> map = new HashMap<String, String>(8);
        DBRequest dbRequest = new DBRequest();
        String querySql = "select fappid,fapiname,ftimeout from t_monitor_rpc_config where fclustername = ?";
        ArrayList queryList = new ArrayList(1);
        Collections.addAll(queryList, Instance.getClusterName());
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
        List rows = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        for (Result row : rows) {
            String appId = row.getString("fappid");
            String apiName = row.getString("fapiname");
            String timeout = row.getString("ftimeout");
            if (StringUtils.isNotEmpty((String)appId)) {
                String key = appId + "." + apiName;
                map.put(key, timeout);
                continue;
            }
            map.put(apiName, timeout);
        }
        return map;
    }

    private static void setSystemProperty(Map<String, String> map) {
        if (map == null || map.size() == 0) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            System.setProperty("mservice.rpc." + entry.getKey(), entry.getValue());
        }
    }

    private static final class RpcConfigChangeListener
    implements EyeConfigChangeListener {
        private RpcConfigChangeListener() {
        }

        @Override
        public void configUpdate(String key, String value) {
            System.setProperty("mservice.rpc." + key, value);
        }
    }
}

