/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.dashboard.AbstractDashboardHandler;
import kd.bos.eye.api.dashboard.vo.Dashboard;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class DeleteDashboardHandler
extends AbstractDashboardHandler {
    private static final Log log = LogFactory.getLog(DeleteDashboardHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    protected void handle1(HttpExchange exchange) throws IOException {
        ApiResponse<HashMap<String, String>> response = new ApiResponse<HashMap<String, String>>();
        try {
            Dashboard param = ExchangeVueUtils.parseJsonFromPost(exchange, Dashboard.class);
            if (param != null && StringUtils.isNotEmpty((String)param.getId())) {
                response.setCode(0);
                response.setMsg("success");
                String id = param.getId();
                HashMap<String, String> retMap = new HashMap<String, String>(1);
                retMap.put("isUsed", "false");
                this.deleteDashboard(id, retMap, this.isFromCosmiceye(exchange), exchange);
                response.setData(retMap);
            } else {
                response.setCode(-1);
                response.setMsg("Fail. The parameter of id is necessary");
            }
        }
        catch (Exception e) {
            log.error("Delete widget error:", (Throwable)e);
            response.setCode(-1);
            response.setMsg("Exception:" + e.getMessage());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private void deleteDashboard(String id, Map<String, String> retMap, boolean isFromCosmiceye, HttpExchange exchange) {
        String tableName;
        String string = tableName = isFromCosmiceye ? "t_monitor_cosmiceye_dashboard" : "t_monitor_dashboard";
        if (this.isUsedDashboard(id, isFromCosmiceye)) {
            retMap.put("isUsed", "true");
            return;
        }
        ArrayList<String> paramList = new ArrayList<String>(1);
        paramList.add(id);
        DBRequest dbRequest = new DBRequest();
        String sql = String.format("delete from %s where fid=?", tableName);
        dbRequest.setDeleteRequest(new DBRequest.DeleteRequest(sql, paramList));
        MetadataFactory.getStatement().executeDelete((Request)dbRequest);
        OPLOGGER.opLog(exchange, OpType.DELETE, LangRes.get((String)"DashboardHandler_1", (String)"\u76d1\u63a7\u5927\u76d8", (Object[])new Object[0]), LangRes.get((String)"DashboardHandler_2", (String)"\u5220\u9664\u76d1\u63a7\u5927\u76d8", (Object[])new Object[0]));
    }

    private boolean isUsedDashboard(String id, boolean isFromCosmiceye) {
        String tableName = isFromCosmiceye ? "t_monitor_cosmiceye_relation" : "t_monitor_dashboard_relation";
        DBRequest dbRequest = new DBRequest();
        String sql = String.format("select fid from %s where fdashboard=?", tableName);
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(sql, Collections.singletonList(id)));
        List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        return result.size() > 0;
    }
}

