/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.eye.api.dashboard.AbstractDashboardHandler;
import kd.bos.eye.api.dashboard.lang.DashboardLangResBundle;
import kd.bos.eye.api.dashboard.vo.Dashboard;
import kd.bos.eye.api.dashboard.vo.QueryDashboardParam;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class QueryDashboardHandler
extends AbstractDashboardHandler {
    private static final Log log = LogFactory.getLog(QueryDashboardHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    protected void handle1(HttpExchange exchange) throws IOException {
        ApiResponse<List<Dashboard>> response = new ApiResponse<List<Dashboard>>();
        try {
            List<Dashboard> retList;
            QueryDashboardParam queryParam = ExchangeVueUtils.parseJsonFromPost(exchange, QueryDashboardParam.class);
            boolean isFromCosmiceye = this.isFromCosmiceye(exchange);
            if (queryParam == null || StringUtils.isEmpty((String)queryParam.getHome()) && StringUtils.isEmpty((String)queryParam.getKeyWord())) {
                retList = this.getHomeDashboards("", isFromCosmiceye);
            } else {
                StringBuilder condition = new StringBuilder(" where ");
                boolean flag = false;
                if (StringUtils.isNotEmpty((String)queryParam.getHome())) {
                    condition.append(" fhome=").append(queryParam.getHome());
                    flag = true;
                }
                if (StringUtils.isNotEmpty((String)queryParam.getKeyWord())) {
                    String word = "%" + queryParam.getKeyWord() + "%";
                    String val = String.format(" ftitle like '%s' or fremark like '%s'", word, word);
                    condition = flag ? condition.append(" and ").append(val) : condition.append(val);
                }
                retList = this.getHomeDashboards(condition.toString(), isFromCosmiceye);
            }
            if (DashboardLangResBundle.isNeedTranslate()) {
                for (Dashboard dashboard : retList) {
                    dashboard.setTitle(DashboardLangResBundle.translate(dashboard.getTitle()));
                    dashboard.setRemark(DashboardLangResBundle.translate(dashboard.getRemark()));
                    String translate = DashboardLangResBundle.translateAll(dashboard.getLayout());
                    dashboard.setLayout(translate);
                }
            }
            response.setCode(0);
            response.setData(retList);
            response.setMsg("success");
        }
        catch (Exception e) {
            log.error("Query dashboard error\uff1a", (Throwable)e);
            response.setCode(-1);
            response.setMsg(e.getMessage());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private List<Dashboard> getHomeDashboards(String condition, boolean isFromCosmiceye) {
        if (isFromCosmiceye) {
            return this.getHomeCosmiceyeDashboards(condition);
        }
        DBRequest dbRequest = new DBRequest();
        String querySql = "select fid,ftitle,fbgimg,flayout,fwidgets,fhome,fremark,fcreated,fupdated,fstyle from t_monitor_dashboard" + condition;
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, new ArrayList()));
        List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        ArrayList<Dashboard> retList = new ArrayList<Dashboard>(result.size());
        for (Result row : result) {
            Dashboard dashboard = new Dashboard();
            dashboard.setId(row.getString("fid"));
            dashboard.setTitle(row.getString("ftitle"));
            dashboard.setBgImg(row.getString("fbgimg"));
            dashboard.setLayout(row.getString("flayout"));
            dashboard.setWidgets(row.getString("fwidgets"));
            boolean home = "1".equals(row.getString("fhome"));
            dashboard.setHome(home);
            dashboard.setRemark(row.getString("fremark"));
            dashboard.setCreated(row.getString("fcreated"));
            dashboard.setUpdated(row.getString("fupdated"));
            dashboard.setDashboardStyle(row.getString("fstyle"));
            retList.add(dashboard);
        }
        return retList;
    }

    private List<Dashboard> getHomeCosmiceyeDashboards(String condition) {
        DBRequest dbRequest = new DBRequest();
        String querySql = "select fid,ftitle,flevel,flayout,fhome,fremark,fcreated,fupdated,fstyle from t_monitor_cosmiceye_dashboard " + condition;
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, new ArrayList()));
        List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        ArrayList<Dashboard> retList = new ArrayList<Dashboard>(result.size());
        for (Result row : result) {
            Dashboard dashboard = new Dashboard();
            dashboard.setId(row.getString("fid"));
            dashboard.setTitle(row.getString("ftitle"));
            dashboard.setLevel(row.getString("flevel"));
            dashboard.setLayout(row.getString("flayout"));
            boolean home = "1".equals(row.getString("fhome"));
            dashboard.setHome(home);
            dashboard.setRemark(row.getString("fremark"));
            dashboard.setCreated(row.getString("fcreated"));
            dashboard.setUpdated(row.getString("fupdated"));
            dashboard.setDashboardStyle(row.getString("fstyle"));
            retList.add(dashboard);
        }
        return retList;
    }
}

