/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import kd.bos.db.DB;
import kd.bos.eye.api.dashboard.AbstractDashboardHandler;
import kd.bos.eye.api.dashboard.vo.DashboardRelation;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class SaveDashboardRelationHandler
extends AbstractDashboardHandler {
    private static final Log log = LogFactory.getLog(SaveDashboardRelationHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    protected void handle1(HttpExchange exchange) throws IOException {
        DashboardRelation body = ExchangeVueUtils.parseJsonFromPost(exchange, DashboardRelation.class);
        ApiResponse response = new ApiResponse();
        try {
            if (body == null || StringUtils.isEmpty((String)body.getOwner()) || StringUtils.isEmpty((String)body.getDashboardId())) {
                response.setCode(-1);
                response.setMsg("error: The parameter is missing");
                this.writeJson(JSONUtils.toString(response), exchange);
                return;
            }
            boolean isFromCosmiceye = this.isFromCosmiceye(exchange);
            if (1 == body.getType()) {
                this.saveDashboardRelation(body, isFromCosmiceye);
                OPLOGGER.opLog(exchange, OpType.ADD, LangRes.get((String)"DashboardHandler_1", (String)"\u76d1\u63a7\u5927\u76d8", (Object[])new Object[0]), LangRes.get((String)"DashboardHandler_7", (String)"\u65b0\u589e\u5927\u76d8\u5173\u8054\u5173\u7cfb", (Object[])new Object[0]));
            } else {
                this.deleteDashboardRelation(body.getOwner(), body.getDashboardId(), isFromCosmiceye);
                OPLOGGER.opLog(exchange, OpType.DELETE, LangRes.get((String)"DashboardHandler_1", (String)"\u76d1\u63a7\u5927\u76d8", (Object[])new Object[0]), LangRes.get((String)"DashboardHandler_8", (String)"\u5220\u9664\u5927\u76d8\u5173\u8054\u5173\u7cfb", (Object[])new Object[0]));
            }
            response.setCode(0);
            response.setMsg("success");
        }
        catch (Exception e) {
            log.error("Save dashboard relation error:", (Throwable)e);
            response.setCode(-1);
            response.setMsg("Exception:" + e.getMessage());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private void saveDashboardRelation(DashboardRelation relation, boolean isFromCosmiceye) {
        String tableName = isFromCosmiceye ? "t_monitor_cosmiceye_relation" : "t_monitor_dashboard_relation";
        relation.setId(DB.genStringId((String)tableName));
        ArrayList<Object> paramList = new ArrayList<Object>(4);
        paramList.add(relation.getId());
        paramList.add(relation.getOwner());
        paramList.add(relation.getDashboardId());
        paramList.add(relation.getSort());
        String sql = String.format("insert into %s values(?,?,?,?)", tableName);
        DBRequest dbRequest = new DBRequest();
        dbRequest.setInsertRequest(new DBRequest.InsertRequest(sql, paramList));
        MetadataFactory.getStatement().executeInsert((Request)dbRequest);
    }

    private void deleteDashboardRelation(String owner, String dashboardId, boolean isFromCosmiceye) {
        String tableName = isFromCosmiceye ? "t_monitor_cosmiceye_relation" : "t_monitor_dashboard_relation";
        ArrayList<String> paramList = new ArrayList<String>(2);
        paramList.add(owner);
        paramList.add(dashboardId);
        DBRequest dbRequest = new DBRequest();
        String sql = String.format("delete from %s where fowner=? and fdashboard=?", tableName);
        dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(sql, paramList));
        MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
    }
}

