/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.es;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kd.bos.government.storage.impl.elasticsearch.client.ElasticsearchConfig;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;

public class EsClient {
    private static final Log logger = LogFactory.getLog(EsClient.class);
    private RestHighLevelClient esClient;

    public EsClient() {
        ElasticsearchConfig elasticsearchConfig = new ElasticsearchConfig();
        this.buildClient(elasticsearchConfig);
    }

    public SearchResponse search(SearchRequest searchRequest, RequestOptions options) {
        try {
            return this.esClient.search(searchRequest, options);
        }
        catch (Exception e) {
            logger.error("monitor dashboard query metrics error,msg={}", (Object)e.getMessage());
            return new SearchResponse();
        }
    }

    private void buildClient(ElasticsearchConfig config) {
        try {
            SSLContext sslContext;
            String userName = config.getUserName();
            String password = config.getPassword();
            if ("https".equals(config.getSchema())) {
                if (StringUtils.isEmpty((String)config.getCertPath())) {
                    SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustAllStrategy());
                    sslContext = sslContextBuilder.build();
                } else {
                    Path trustStorePath = Paths.get(config.getCertPath(), new String[0]);
                    KeyStore trustStore = KeyStore.getInstance("pkcs12");
                    trustStore.load(Files.newInputStream(trustStorePath, new OpenOption[0]), config.getCertPassword().toCharArray());
                    SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial(trustStore, null);
                    sslContext = sslContextBuilder.build();
                }
            } else {
                sslContext = null;
            }
            if (userName != null && password != null) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
                this.esClient = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(config.getIp(), config.getPort(), config.getSchema())}).setHttpClientConfigCallback(arg_0 -> EsClient.lambda$buildClient$0(sslContext, (CredentialsProvider)credentialsProvider, arg_0)));
            } else {
                this.esClient = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(config.getIp(), config.getPort(), config.getSchema())}).setHttpClientConfigCallback(httpClientBuilder -> {
                    httpClientBuilder.setSSLContext(sslContext);
                    httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                    return httpClientBuilder;
                }));
            }
        }
        catch (Exception e) {
            logger.error("dashboard metrics init highLevelAccessClient error", (Throwable)e);
        }
    }

    public void close() {
        try {
            if (this.esClient != null) {
                this.esClient.close();
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$buildClient$0(SSLContext sslContext, CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.disableAuthCaching();
        httpClientBuilder.setSSLContext(sslContext);
        httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

