/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.init;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kd.bos.dlock.DLock;
import kd.bos.eye.api.dashboard.AbstractDashboardHandler;
import kd.bos.eye.api.dashboard.init.CosmiceyeDashboardHelper;
import kd.bos.eye.api.dashboard.vo.Dashboard;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.bos.util.JSONUtils;

public class DashboardHelper {
    private static final String TABLE_LIST = "t_monitor_dashboard,t_monitor_widgets,t_monitor_dashboard_relation";
    private static final String EXCLUDE_TABLE = "t_monitor_dashboard";
    private static final String LOCK_PATH = "/dlock/monitor/dashboard/dashboardDataInit";
    private static Log log = LogFactory.getLog(AbstractDashboardHandler.class);
    private static boolean needUpdate;

    public static void init() {
        DLock dLock = null;
        try {
            if (!DBHelper.dbIsConfigured()) {
                return;
            }
            dLock = DLock.create((String)LOCK_PATH);
            if (!dLock.tryLock()) {
                return;
            }
            ThreadPools.executeOnce((String)"DashboardDataInitThread", () -> DashboardHelper.doInit());
            ThreadPools.executeOnce((String)"CosmicDashboardDataInitThread", () -> CosmiceyeDashboardHelper.doInit());
        }
        catch (Exception e) {
            log.error("DashboardHelper init data error", (Throwable)e);
        }
        finally {
            if (dLock != null) {
                dLock.unlock();
            }
        }
    }

    private static void doInit() {
        String[] tableList;
        for (String tableName : tableList = TABLE_LIST.split(",")) {
            DashboardHelper.initData(tableName);
        }
    }

    private static void initData(String tableName) {
        if (DashboardHelper.existData(tableName)) {
            if (EXCLUDE_TABLE.equals(tableName)) {
                needUpdate = true;
                DashboardHelper.initDashboard();
            }
            return;
        }
        if (EXCLUDE_TABLE.equals(tableName)) {
            DashboardHelper.initDashboard();
            return;
        }
        String fileName = tableName + ".sql";
        ArrayList<String> sqlList = new ArrayList<String>(16);
        StringBuilder sb = new StringBuilder();
        try (InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("scripts/" + fileName);
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(resourceAsStream));
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                if ("".equals(line)) {
                    sqlList.add(sb.toString());
                    sb = new StringBuilder();
                    continue;
                }
                sb.append(line);
            }
            sqlList.add(sb.toString());
            for (String sql : sqlList) {
                DashboardHelper.insertData(sql);
            }
        }
        catch (Exception e) {
            log.warn("DashboardHelper init " + tableName + " data error", (Throwable)e);
        }
    }

    private static boolean existData(String tableName) {
        String sql = "SELECT COUNT(*) AS num FROM " + tableName;
        DBRequest dbRequest = new DBRequest();
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(sql, Collections.EMPTY_LIST));
        List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        String totalNum = ((Result)results.get(0)).getString("num");
        return Integer.parseInt(totalNum) > 0;
    }

    private static boolean existTable(String tableName) {
        String tableSql = String.format("SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s'", tableName);
        DBRequest dbRequest = new DBRequest();
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(tableSql, Collections.EMPTY_LIST));
        List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        return !results.isEmpty();
    }

    private static void insertData(String sql) {
        DBRequest dbRequest = new DBRequest();
        dbRequest.setInsertRequest(new DBRequest.InsertRequest(sql, Collections.EMPTY_LIST));
        MetadataFactory.getStatement().executeInsert((Request)dbRequest);
    }

    private static void initDashboard() {
        String fileName = "dashboard.json";
        StringBuilder sb = new StringBuilder();
        try (InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("scripts/" + fileName);
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(resourceAsStream));
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            List dashboards = (List)JSONUtils.cast((String)sb.toString(), List.class, (Class[])new Class[]{Dashboard.class});
            for (Dashboard dashboard : dashboards) {
                if (needUpdate) {
                    DashboardHelper.updateDashboard(dashboard);
                    continue;
                }
                DashboardHelper.insertDashboard(dashboard);
            }
        }
        catch (Exception e) {
            log.warn("DashboardHelper init t_monitor_dashboard data error", (Throwable)e);
        }
    }

    private static void insertDashboard(Dashboard dashboard) {
        ArrayList<Object> paramList = new ArrayList<Object>(10);
        paramList.add(dashboard.getId());
        paramList.add(dashboard.getTitle());
        paramList.add(dashboard.getBgImg());
        paramList.add(dashboard.isHome());
        paramList.add(dashboard.getLayout());
        paramList.add(dashboard.getWidgets());
        paramList.add(dashboard.getRemark());
        paramList.add(dashboard.getDashboardStyle());
        String sql = "insert into t_monitor_dashboard values(?,?,?,?,?,?,?,now(),now(),?)";
        DBRequest dbRequest = new DBRequest();
        dbRequest.setInsertRequest(new DBRequest.InsertRequest(sql, paramList));
        MetadataFactory.getStatement().executeInsert((Request)dbRequest);
    }

    private static void updateDashboard(Dashboard dashboard) {
        ArrayList<Object> paramList = new ArrayList<Object>(10);
        paramList.add(dashboard.getTitle());
        paramList.add(dashboard.getBgImg());
        paramList.add(dashboard.isHome());
        paramList.add(dashboard.getLayout());
        paramList.add(dashboard.getWidgets());
        paramList.add(dashboard.getRemark());
        paramList.add(dashboard.getDashboardStyle());
        paramList.add(dashboard.getId());
        String sql = "update t_monitor_dashboard set ftitle=?,fbgimg=?,fhome=?,flayout=?,fwidgets=?,fremark=?,fstyle=? where fid=?";
        DBRequest dbRequest = new DBRequest();
        dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(sql, paramList));
        MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
    }

    private static void updateData() {
        String fileName = "update.sql";
        ArrayList<String> sqlList = new ArrayList<String>(2);
        StringBuilder sb = new StringBuilder();
        try (InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("scripts/" + fileName);
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(resourceAsStream));
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                if ("".equals(line)) {
                    sqlList.add(sb.toString());
                    sb = new StringBuilder();
                    continue;
                }
                sb.append(line);
            }
            sqlList.add(sb.toString());
            for (String sql : sqlList) {
                DBRequest dbRequest = new DBRequest();
                dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(sql, Collections.EMPTY_LIST));
                MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
            }
        }
        catch (Exception e) {
            log.warn("DashboardHelper init data error", (Throwable)e);
        }
    }
}

